/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclaratorId;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;
import java.util.List;

public final class Parameter
extends Node
implements NodeWithType<Parameter>,
NodeWithAnnotations<Parameter>,
NodeWithName<Parameter>,
NodeWithModifiers<Parameter> {
    private Type type;
    private boolean isVarArgs;
    private EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
    private List<AnnotationExpr> annotations;
    private VariableDeclaratorId id;

    public Parameter() {
    }

    public Parameter(Type type, VariableDeclaratorId id) {
        this.setId(id);
        this.setType(type);
    }

    public static Parameter create(Type type, String name) {
        return new Parameter(type, new VariableDeclaratorId(name));
    }

    public Parameter(EnumSet<Modifier> modifiers, Type type, VariableDeclaratorId id) {
        this.setModifiers((EnumSet)modifiers);
        this.setId(id);
        this.setType(type);
    }

    public Parameter(Range range, EnumSet<Modifier> modifiers, List<AnnotationExpr> annotations, Type type, boolean isVarArgs, VariableDeclaratorId id) {
        super(range);
        this.setModifiers((EnumSet)modifiers);
        this.setAnnotations((List)annotations);
        this.setId(id);
        this.setType(type);
        this.setVarArgs(isVarArgs);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    @Override
    public Parameter setType(Type type) {
        this.type = type;
        this.setAsParentNodeOf(this.type);
        return this;
    }

    public void setVarArgs(boolean isVarArgs) {
        this.isVarArgs = isVarArgs;
    }

    @Override
    public List<AnnotationExpr> getAnnotations() {
        this.annotations = Utils.ensureNotNull(this.annotations);
        return this.annotations;
    }

    public VariableDeclaratorId getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.getId().getName();
    }

    @Override
    public Parameter setName(String name) {
        if (this.id != null) {
            this.id.setName(name);
        } else {
            this.id = new VariableDeclaratorId(name);
        }
        return this;
    }

    @Override
    public EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public Parameter setAnnotations(List<AnnotationExpr> annotations) {
        this.annotations = annotations;
        this.setAsParentNodeOf(this.annotations);
        return this;
    }

    public void setId(VariableDeclaratorId id) {
        this.id = id;
        this.setAsParentNodeOf(this.id);
    }

    @Override
    public Parameter setModifiers(EnumSet<Modifier> modifiers) {
        this.modifiers = modifiers;
        return this;
    }
}

