/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.tabbed;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jvnet.lafwidget.LafWidgetAdapter;
import org.jvnet.lafwidget.LafWidgetUtilities2;
import org.jvnet.lafwidget.Resettable;
import org.jvnet.lafwidget.tabbed.TabPagerManager;
import org.jvnet.lafwidget.tabbed.TabPagerMouseWheelListener;
import org.jvnet.lafwidget.tabbed.TabPreviewPainter;

public class TabPagerWidget
extends LafWidgetAdapter
implements Resettable {
    protected JTabbedPane jtp;
    protected MouseWheelListener mouseWheelListener;
    protected MouseListener mouseListener;

    public void setComponent(JComponent jcomp) {
        super.setComponent(jcomp);
        this.jtp = (JTabbedPane)jcomp;
    }

    public void installUI() {
        super.installUI();
        InputMap currMap = SwingUtilities.getUIInputMap(this.jtp, 1);
        InputMap newMap = new InputMap();
        if (currMap != null) {
            KeyStroke[] kss = currMap.allKeys();
            for (int i = 0; i < kss.length; ++i) {
                KeyStroke stroke = kss[i];
                Object val = currMap.get(stroke);
                newMap.put(stroke, val);
            }
        }
        newMap.put(KeyStroke.getKeyStroke(39, 2), "tabSwitcherForward");
        newMap.put(KeyStroke.getKeyStroke(37, 2), "tabSwitcherBackward");
        newMap.put(KeyStroke.getKeyStroke(17, 0, true), "tabSwitcherClose");
        newMap.put(KeyStroke.getKeyStroke(27, 0), "tabSwitcherHide");
        this.jtp.getActionMap().put("tabSwitcherForward", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TabPagerManager te = TabPagerManager.getPager();
                te.page(TabPagerWidget.this.jtp, true);
            }
        });
        this.jtp.getActionMap().put("tabSwitcherBackward", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TabPagerManager te = TabPagerManager.getPager();
                te.page(TabPagerWidget.this.jtp, false);
            }
        });
        this.jtp.getActionMap().put("tabSwitcherClose", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TabPagerManager te = TabPagerManager.getPager();
                        int index = te.hide();
                        TabPreviewPainter tpp = LafWidgetUtilities2.getTabPreviewPainter(TabPagerWidget.this.jtp);
                        if (index >= 0 && tpp.isSensitiveToEvents(TabPagerWidget.this.jtp, index)) {
                            TabPagerWidget.this.jtp.setSelectedIndex(index);
                        }
                    }
                });
            }
        });
        this.jtp.getActionMap().put("tabSwitcherHide", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TabPagerManager te = TabPagerManager.getPager();
                if (te.isVisible()) {
                    te.hide();
                } else {
                    for (Container comp = TabPagerWidget.this.jtp.getParent(); comp != null; comp = comp.getParent()) {
                        KeyStroke escapeKeyStroke;
                        JComponent jc;
                        ActionListener al;
                        if (!(comp instanceof JComponent) || (al = (jc = (JComponent)comp).getActionForKeyStroke(escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false))) == null) continue;
                        al.actionPerformed(e);
                        return;
                    }
                }
            }
        });
        SwingUtilities.replaceUIInputMap(this.jtp, 1, newMap);
    }

    public void uninstallUI() {
        super.uninstallUI();
    }

    public void installListeners() {
        this.mouseWheelListener = new TabPagerMouseWheelListener(this.jtp);
        this.jtp.addMouseWheelListener(this.mouseWheelListener);
        this.mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 2) != 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            TabPagerManager te = TabPagerManager.getPager();
                            int index = te.hide();
                            if (index >= 0) {
                                TabPagerWidget.this.jtp.setSelectedIndex(index);
                            }
                        }
                    });
                }
            }
        };
        this.jtp.addMouseListener(this.mouseListener);
    }

    public void uninstallListeners() {
        this.jtp.removeMouseWheelListener(this.mouseWheelListener);
        this.mouseWheelListener = null;
        this.jtp.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
    }

    public boolean requiresCustomLafSupport() {
        return false;
    }

    public void reset() {
        TabPagerManager.reset();
    }
}

