/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.title;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.painter.ClassicGradientPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.SubstanceTitlePainter;
import org.jvnet.substance.utils.SoftHashMap;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class ClassicTitlePainter
implements SubstanceTitlePainter {
    public static final String DISPLAY_NAME = "Classic";
    protected static Map<String, BufferedImage> smallImageCache = new SoftHashMap<String, BufferedImage>();
    protected ClassicGradientPainter painter = new ClassicGradientPainter();

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintTitleBackground(Graphics2D graphics, Component comp, int width, int height, int leftTitleX, int rightTitleX, SubstanceTheme theme, float borderAlpha) {
        int size = Math.max(width, height);
        if (size < 150) {
            ClassicTitlePainter classicTitlePainter = this;
            synchronized (classicTitlePainter) {
                String key = width + "*" + height + "*" + leftTitleX + "*" + rightTitleX + "*" + theme.getDisplayName() + "*" + borderAlpha;
                BufferedImage result = smallImageCache.get(key);
                if (result == null) {
                    result = SubstanceCoreUtilities.getBlankImage(width, height);
                    this.internalPaint((Graphics2D)result.getGraphics(), width, height, leftTitleX, rightTitleX, theme, borderAlpha);
                    smallImageCache.put(key, result);
                }
                graphics.drawImage((Image)result, 0, 0, null);
                return;
            }
        }
        this.internalPaint(graphics, width, height, leftTitleX, rightTitleX, theme, borderAlpha);
    }

    protected void internalPaint(Graphics2D graphics, int width, int height, int leftTitleX, int rightTitleX, SubstanceTheme theme, float borderAlpha) {
        graphics.setColor(theme.getActiveTitlePaneTheme().getColorScheme().getMidColor());
        graphics.drawImage((Image)this.painter.getContourBackground(width + 6, height + 6, new Rectangle(width + 6, height + 6), false, theme.getActiveTitlePaneTheme().getColorScheme(), theme.getActiveTitlePaneTheme().getColorScheme(), 0.0f, false, false), -3, -3, null);
        if (borderAlpha > 0.0f) {
            Graphics2D g2d = (Graphics2D)graphics.create();
            g2d.setComposite(TransitionLayout.getAlphaComposite(null, borderAlpha, graphics));
            SubstanceImageCreator.paintBorder(null, g2d, 0, 0, width, height, 0.0f, theme.getActiveTitlePaneTheme());
            g2d.dispose();
        }
    }

    public static synchronized void reset() {
        smallImageCache.clear();
    }
}

