/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.webapp.UIComponentClassicTagBase;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

public class ConverterTag
extends TagSupport {
    private static final long serialVersionUID = -5909792518081427720L;
    private String converterId = null;
    private String binding = null;

    public void setConverterId(String converterId) {
        this.converterId = converterId;
    }

    public void setBinding(String binding) throws JspException {
        if (binding != null && !UIComponentTag.isValueReference((String)binding)) {
            throw new JspException("Invalid Expression:" + binding);
        }
        this.binding = binding;
    }

    public int doStartTag() throws JspException {
        UIComponentClassicTagBase tag = UIComponentClassicTagBase.getParentUIComponentClassicTagBase((PageContext)this.pageContext);
        if (tag == null) {
            throw new JspException("Not nested in a UIComponentTag Error for tag with handler class:" + this.getClass().getName());
        }
        if (!tag.getCreated()) {
            return 0;
        }
        UIComponent component = tag.getComponentInstance();
        if (component == null) {
            throw new JspException("Can't create Component from tag.");
        }
        if (!(component instanceof ValueHolder)) {
            throw new JspException("Not nested in a tag of proper type. Error for tag with handler class:" + this.getClass().getName());
        }
        Converter converter = this.createConverter();
        if (converter == null) {
            String converterError = null;
            if (this.binding != null) {
                converterError = this.binding;
            }
            if (this.converterId != null) {
                converterError = converterError != null ? converterError + " or " + this.converterId : this.converterId;
            }
            throw new JspException("Can't create class of type:javax.faces.convert.Converter for:" + converterError);
        }
        ValueHolder vh = (ValueHolder)component;
        FacesContext context = FacesContext.getCurrentInstance();
        vh.setConverter(converter);
        Object localValue = vh.getLocalValue();
        if (localValue instanceof String) {
            try {
                localValue = converter.getAsObject(context, (UIComponent)vh, (String)localValue);
                vh.setValue(localValue);
            }
            catch (ConverterException ce) {
                // empty catch block
            }
        }
        return 0;
    }

    public void release() {
        this.converterId = null;
    }

    protected Converter createConverter() throws JspException {
        FacesContext context = FacesContext.getCurrentInstance();
        Converter converter = null;
        ValueExpression vb = null;
        if (this.binding != null) {
            try {
                vb = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), this.binding, Object.class);
                if (vb != null && (converter = (Converter)vb.getValue(context.getELContext())) != null) {
                    return converter;
                }
            }
            catch (Exception e) {
                throw new JspException((Throwable)e);
            }
        }
        if (this.converterId != null) {
            try {
                String converterIdVal = this.converterId;
                if (UIComponentTag.isValueReference((String)this.converterId)) {
                    ValueExpression idBinding = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), this.converterId, Object.class);
                    converterIdVal = (String)idBinding.getValue(context.getELContext());
                }
                if ((converter = context.getApplication().createConverter(converterIdVal)) != null && vb != null) {
                    vb.setValue(context.getELContext(), (Object)converter);
                }
            }
            catch (Exception e) {
                throw new JspException((Throwable)e);
            }
        }
        return converter;
    }
}

