/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.processmigration.rest;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.eclipse.microprofile.health.Health;
import org.kie.processmigration.service.StatusService;

@Path("/health")
@Produces(MediaType.APPLICATION_JSON)
public class HealthStatusResource {

    @Inject
    private StatusService statusService;

    @GET
    @Path("/readiness")
    @Health
    public Response checkReadiness() {
        return Response.ok(statusService.getHealth()).build();
    }

    @GET
    @Path("/status")
    public Response getStatus() {
        return Response.ok(statusService.getStatus()).build();
    }

}
