package com.redhat.installer.asconfiguration.ascontroller;

import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.*;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandLineException;

/**
 * Created by thauser on 10/20/15.
 */
public abstract class EmbeddedController extends SimpleInstallerListener implements CleanupClient {

    private static AutomatedInstallData idata;
    private static AbstractUIProcessHandler mHandler;
    private static boolean isSlave = false;

    public boolean run(AbstractUIProcessHandler handler, String[]args){
        System.setProperty("jboss.domain.master.address", "127.0.0.1");
        isSlave = false;
        mHandler = handler;
        idata = AutomatedInstallData.getInstance();
        CommandContext embeddedServer = (CommandContext) idata.getAttribute(getServerVariable());
        if(args.length == 0 && embeddedServer == null) {
            return false;
        }
        if (embeddedServer == null){
            if (args[0].equals("host-slave.xml"))
                isSlave = true;
            return startEmbeddedServer(args[0]);
        } else {
            return stopEmbeddedServer(embeddedServer);
        }
    }
    private boolean stopEmbeddedServer(CommandContext embeddedServer) {
        try {
            embeddedServer.handle(getShutdownCommand());
        } catch (CommandLineException e) {
            Debug.log(e);
            return false;
        }
        ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("EmbeddedController.shutdown"), false);
        idata.setAttribute(getServerVariable(), null);
        return true;
    }

    private boolean startEmbeddedServer(String descriptor) {
        CommandContext cc;
        try {
            cc = CommandContextFactory.getInstance().newCommandContext();
            cc.setSilent(true);
            cc.handle(String.format(getStartCommand(), idata.getInstallPath(), descriptor));
        } catch (CliInitializationException e) {
            Debug.log(e);
            ProcessPanelHelper.printToPanel(mHandler, e.getMessage(), true);
            return false;
        } catch (CommandLineException e) {
            Debug.log(e);
            ProcessPanelHelper.printToPanel(mHandler, e.getMessage(), true);
            return false;
        }
        ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("EmbeddedController.success"), descriptor), false);
        idata.setAttribute(getServerVariable(), cc);
        return true;
    }

    @Override
    public void beforePacks(AutomatedInstallData idata, Integer x,
                            AbstractUIProgressHandler handler) throws Exception {
        Debug.log("Registering EmbeddedController for Cleanup.");
        Housekeeper.getInstance().registerForCleanup(this);
    }


    @Override
    public void cleanUp(){
        CommandContext cc = (CommandContext) idata.getAttribute(getServerVariable());
        if (cc != null){
            try {
                stopEmbeddedServer(cc);
            } catch (Exception e){
                e.printStackTrace();
            }
        }
    }
    public static boolean isSlave(){
        return isSlave;
    }
    public abstract String getServerVariable();
    public abstract String getStartCommand();
    public abstract String getShutdownCommand();
}
