package com.redhat.installer.asconfiguration.jsf;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.MultiMessageValidator;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;

/**
 * Created by dsoukhov on 23/09/16.
 */
public class JsfVersionValidator implements Validator, MultiMessageValidator {

    public String formatedMessage;
    AutomatedInstallData adata = AutomatedInstallData.getInstance();

    @Override
    public String getMessage() {
        return formatedMessage;
    }

    public void setFormattedMessage(String message) {

        formatedMessage = message;
    }

    @Override
    public Status validate(ProcessingClient client) {

        String ver = client.getText();
        if(ver.trim().equals("")){
            return Status.OK;
        }
        if (JsfUtils.cleanedVer(ver).equals("")){
            setFormattedMessage(String.format(adata.langpack.getString("jsf.version.not.supported"), ver));
            return Status.ERROR;
        }
        return Status.OK;
    }
}
