package com.redhat.installer.installation.action.defaults;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;

import java.util.Map;

public abstract class SetDefaults implements PanelAction {
    @Override
    public void executeAction(AutomatedInstallData adata, AbstractUIHandler handler) {
        Map<String, String> defaults = getDefaultMap();

        for (Map.Entry<String, String> entry : defaults.entrySet()) {
            adata.setVariable(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void initialize(PanelActionConfiguration configuration) {
    }

    public abstract Map<String, String> getDefaultMap();
}
