package com.redhat.installer.installation.maven.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.VariableSubstitutor;

import java.io.File;

/**
 * Created by thauser on 5/4/15.
 */
public class MavenRepositoryValidator implements DataValidator {
    private String[] supportedProtocols = new String[]{"http","https","ftp"};
    private AutomatedInstallData idata;
    private String errorMessageId;
    private String formattedMessage;
    private String warningMessageId;

    @Override
    public Status validateData(AutomatedInstallData adata) {
        idata = adata;
        return setMavenRepository();
    }

    private Status setMavenRepository() {
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        boolean useDefault = Boolean.parseBoolean(idata.getVariable("useDefaultMavenRepoLocation"));
        if (useDefault) {
            idata.setVariable("MAVEN_REPO_PATH", vs.substitute(idata.getVariable("MAVEN_REPO_PATH.default")));
            return Status.OK;
        } else {
            return setUserSpecifiedRepository();
        }
    }

    private Status setUserSpecifiedRepository() {
        String urlType = "";
        String currentPath = idata.getVariable("MAVEN_REPO_PATH");
        if (isSupportedProtocol(currentPath)){
            if (!IoHelper.remoteFileExists(currentPath)){
                setErrorAndMessage("MavenRepoCheckPanel.path.error");
                return Status.ERROR;
            }
        } else {
            if (currentPath.startsWith("file://")){
                // local file
                currentPath = currentPath.substring(7);
            }
            File chosenRepo = new File(currentPath);
            if (!chosenRepo.exists() || !chosenRepo.isDirectory()){
                setErrorAndMessage("MavenRepoCheckPanel.path.error");
                return Status.ERROR;
            }
            urlType = "file://";
        }
        idata.setVariable("MAVEN_REPO_PATH", urlType + currentPath);
        return Status.OK;
    }

    private boolean isSupportedProtocol(String currentPath) {
        for (String protocol : supportedProtocols){
            if (currentPath.startsWith(protocol)){
                return true;
            }
        }
        return false;
    }

    private void setErrorAndMessage(String error, String ... format){
        errorMessageId = error;
        formattedMessage = String.format(idata.langpack.getString(error),format);
    }

    @Override
    public String getErrorMessageId() {
        return errorMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return errorMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }

    @Override
    public String getFormattedMessage() {
        return formattedMessage;
    }
}
