package com.redhat.installer.installation.validator;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;

import java.io.File;

/**
 * Created by eunderhi on 09/11/15.
 */
public class EmptyPathValidator implements Validator {

    @Override
    public Status validate(ProcessingClient client) {
        Status failureStatus = Status.ERROR;
        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get(WARNING_PARAM)))
            failureStatus = Status.WARNING;
        String pathString = client.getFieldContents(0);
        File path = new File(pathString);
        Status validationResult = !path.isFile() ? Status.OK : failureStatus;
        return validationResult;
    }
}
