package com.redhat.installer.layering.validator.container.eap;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.layering.validator.container.BasicVersionValidator;
import com.redhat.installer.layering.validator.container.VersionState;
import com.redhat.installer.layering.validator.container.VersionValidator;
import org.osgi.framework.Version;

public class EapValidator implements VersionValidator {
    private final String minVersion;
    private final String maxVersion;

    public EapValidator(AutomatedInstallData installData) {
        this.minVersion = extractMinVersion(installData);
        this.maxVersion = extractMaxVersion(installData);
    }

    private String extractMinVersion(AutomatedInstallData installData) {
        String majorVersion = installData.getVariable("eap.supported.version.major");
        String minorVersion = installData.getVariable("eap.supported.version.minor");
        String releaseVersion = installData.getVariable("eap.supported.version.micro");
        String minimumReleaseVersion = installData.getVariable("eap.supported.version.min.micro");
        String releaseDesignation = installData.getVariable("eap.supported.version.designation");
        if (minimumReleaseVersion == null) {
            return majorVersion + "." + minorVersion + "." + releaseVersion + "." + releaseDesignation;
        } else {
            return majorVersion + "." + minorVersion + "." + minimumReleaseVersion + "." + releaseDesignation;
        }
    }

    private String extractMaxVersion(AutomatedInstallData installData) {
        String majorVersion = installData.getVariable("eap.maximum.version.major");
        String minorVersion = installData.getVariable("eap.maximum.version.minor");
        int microRelease = Integer.parseInt(installData.getVariable("eap.maximum.version.micro"));
        if (microRelease > 9) {
            microRelease = microRelease % 10;
        }

        String releaseDesignation = installData.getVariable("eap.maximum.version.designation");
        return majorVersion + "." + minorVersion + "." + microRelease + "." + releaseDesignation;
    }

    @Override
    public String minSupportedVersion() {
        return minVersion;
    }

    @Override
    public String maxSupportedVersion() {
        return maxVersion;
    }

    @Override
    public VersionState validate(Version version) {
        BasicVersionValidator basicValidator = new BasicVersionValidator(minVersion, maxVersion);
        return basicValidator.validate(version);
    }
}
