package com.redhat.installer.tests.asconfiguration.jsf;

import com.redhat.installer.asconfiguration.jsf.VerifyJsfProjectValidator;
import com.redhat.installer.tests.TestUtils;
import org.junit.Before;
import org.junit.Test;

/**
 * Created by thauser on 9/30/16.
 */
public class VerifyJsfProjectValidatorTest extends AbstractVerifyJsfValidatorTest {

    private final String projNameVar = "jsf.project.name";


    @Before
    public void setUp() throws Exception{
        idata.langpack = TestUtils.createMockLangpack(tempFolder, "empty.fields.project", "JBossJsfSetupPanel.error.manifest",
                "JBossJsfSetupPanel.setproject", "JBossJsfSetupPanel.error.ProjectMatch", "JBossJsfSetupPanel.error.JarError");
        dv = new VerifyJsfProjectValidator();
    }

    @Test
    public void testMojarra(){
        idata.setVariable(projNameVar, "mojarra");
        assertStatusOk();
    }

    @Test
    public void testMyfaces(){
        idata.setVariable(projNameVar, "myfaces");
        assertStatusCombinedMsgWarning();
    }

    @Test
    public void testAuto(){
        idata.setVariable(projNameVar, "auto");
        assertStatusWarning();
    }

    @Test
    public void testJarError(){
        idata.setVariable(idata.getVariable(toValidateVar), "garbage path that doesn't exist");
        assertStatusError();
    }

    @Test
    public void testEmptyMfAuto(){
        idata.setVariable(apiPathVar, tempFolder.getRoot().getPath() + "/emptyMF.jar");
        idata.setVariable(implPathVar, tempFolder.getRoot().getPath() + "/emptyMF.jar");
        idata.setVariable(projNameVar, "auto");
        assertStatusError();
    }
    @Test
    public void testEmptyMfInput(){
        idata.setVariable(apiPathVar, tempFolder.getRoot().getPath() + "/emptyMF.jar");
        idata.setVariable(implPathVar, tempFolder.getRoot().getPath() + "/emptyMF.jar");
        idata.setVariable(projNameVar, "mojarra");
        assertStatusCombinedMsgWarning();
    }


    @Test
    public void testNoPomMismatch(){
        idata.setVariable(apiPathVar, tempFolder.getRoot().getPath() + "/missingPomMojarraApi.jar");
        idata.setVariable(implPathVar, tempFolder.getRoot().getPath() + "/missingPomMojarraApi.jar");
        idata.setVariable(projNameVar, "myfaces");
        assertStatusCombinedMsgWarning();

    }

    @Test
    public void testNoPomMatch(){
        idata.setVariable(apiPathVar, tempFolder.getRoot().getPath() + "/missingPomMojarraApi.jar");
        idata.setVariable(implPathVar, tempFolder.getRoot().getPath() + "/missingPomMojarraApi.jar");
        idata.setVariable(projNameVar, "mojarra");
        assertStatusOk();

    }
}
