/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.queue;

import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueBrowser;
import javax.jms.TextMessage;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.util.NestedRuntimeException;
import org.objectweb.jtests.jms.framework.PTPTestCase;
import org.objectweb.jtests.jms.framework.TestConfig;

public class QueueBrowserTest
extends PTPTestCase {
    protected QueueBrowser receiverBrowser;
    protected QueueBrowser senderBrowser;

    public void testSenderBrowser() {
        try {
            TextMessage msg;
            TextMessage message_1 = this.senderSession.createTextMessage();
            message_1.setText("testBrowser:message_1");
            TextMessage message_2 = this.senderSession.createTextMessage();
            message_2.setText("testBrowser:message_2");
            this.receiver.close();
            this.sender.send((Message)message_1);
            this.sender.send((Message)message_2);
            Enumeration enumeration = this.senderBrowser.getEnumeration();
            int count = 0;
            while (enumeration.hasMoreElements()) {
                ++count;
                Object obj = enumeration.nextElement();
                QueueBrowserTest.assertTrue((boolean)(obj instanceof TextMessage));
                msg = (TextMessage)obj;
                QueueBrowserTest.assertTrue((boolean)msg.getText().startsWith("testBrowser:message_"));
            }
            QueueBrowserTest.assertEquals((int)2, (int)count);
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            QueueBrowserTest.assertTrue((boolean)(m instanceof TextMessage));
            msg = (TextMessage)m;
            QueueBrowserTest.assertEquals((String)"testBrowser:message_1", (String)msg.getText());
            m = this.receiver.receive(TestConfig.TIMEOUT);
            QueueBrowserTest.assertTrue((boolean)(m instanceof TextMessage));
            msg = (TextMessage)m;
            QueueBrowserTest.assertEquals((String)"testBrowser:message_2", (String)msg.getText());
            enumeration = this.receiverBrowser.getEnumeration();
            QueueBrowserTest.assertTrue((!enumeration.hasMoreElements() ? 1 : 0) != 0);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBrowserWithMessageSelector() {
        try {
            this.senderBrowser = this.senderSession.createBrowser(this.senderQueue, "pi = 3.14159");
            this.receiver.close();
            TextMessage message_1 = this.senderSession.createTextMessage();
            message_1.setText("testBrowserWithMessageSelector:message_1");
            TextMessage message_2 = this.senderSession.createTextMessage();
            message_2.setDoubleProperty("pi", 3.14159);
            message_2.setText("testBrowserWithMessageSelector:message_2");
            this.sender.send((Message)message_1);
            this.sender.send((Message)message_2);
            Enumeration enumeration = this.senderBrowser.getEnumeration();
            int count = 0;
            while (enumeration.hasMoreElements()) {
                ++count;
                Object obj = enumeration.nextElement();
                QueueBrowserTest.assertTrue((boolean)(obj instanceof TextMessage));
                TextMessage msg = (TextMessage)obj;
                QueueBrowserTest.assertEquals((String)"testBrowserWithMessageSelector:message_2", (String)msg.getText());
            }
            QueueBrowserTest.assertEquals((int)1, (int)count);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void setUp() {
        try {
            super.setUp();
            this.receiverBrowser = this.receiverSession.createBrowser(this.receiverQueue);
            this.senderBrowser = this.senderSession.createBrowser(this.senderQueue);
        }
        catch (JMSException e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() {
        try {
            this.receiverBrowser.close();
            this.senderBrowser.close();
            super.tearDown();
        }
        catch (JMSException jMSException) {
        }
        finally {
            this.receiverBrowser = null;
            this.senderBrowser = null;
        }
    }

    public static Test suite() {
        return new TestSuite(QueueBrowserTest.class);
    }

    public QueueBrowserTest(String name) {
        super(name);
    }
}

