/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javassist.CtClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static void setAccessible(AccessibleObject accessibleObject) {
        if (System.getSecurityManager() == null) {
            SetAccessibleAction.NON_PRIVILEGED.setAccessible(accessibleObject);
        } else {
            SetAccessibleAction.PRIVILEGED.setAccessible(accessibleObject);
        }
    }

    static void debugWriteFile(CtClass ctClass) {
        if (System.getSecurityManager() == null) {
            CtClassDebugWriteFileAction.NON_PRIVILEGED.debugWriteFile(ctClass);
        } else {
            CtClassDebugWriteFileAction.PRIVILEGED.debugWriteFile(ctClass);
        }
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
    }

    static Constructor<?>[] getDeclaredConstructors(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return GetDeclaredConstructorsAction.NON_PRIVILEGED.getDeclaredConstructors(clazz);
        }
        return GetDeclaredConstructorsAction.PRIVILEGED.getDeclaredConstructors(clazz);
    }

    static ClassLoader getClassLoader(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return GetClassLoaderAction.NON_PRIVILEGED.getClassLoader(clazz);
        }
        return GetClassLoaderAction.PRIVILEGED.getClassLoader(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GetClassLoaderAction {
        public static final GetClassLoaderAction NON_PRIVILEGED = new GetClassLoaderAction(){

            @Override
            public ClassLoader getClassLoader(Class<?> clazz) {
                return clazz.getClassLoader();
            }
        };
        public static final GetClassLoaderAction PRIVILEGED = new GetClassLoaderAction(){

            @Override
            public ClassLoader getClassLoader(final Class<?> clazz) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return clazz.getClassLoader();
                    }
                });
            }
        };

        public ClassLoader getClassLoader(Class<?> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GetDeclaredConstructorsAction {
        public static final GetDeclaredConstructorsAction NON_PRIVILEGED = new GetDeclaredConstructorsAction(){

            @Override
            public Constructor<?>[] getDeclaredConstructors(Class<?> clazz) {
                return clazz.getDeclaredConstructors();
            }
        };
        public static final GetDeclaredConstructorsAction PRIVILEGED = new GetDeclaredConstructorsAction(){

            @Override
            public Constructor<?>[] getDeclaredConstructors(final Class<?> clazz) {
                return AccessController.doPrivileged(new PrivilegedAction<Constructor<?>[]>(){

                    @Override
                    public Constructor<?>[] run() {
                        return clazz.getDeclaredConstructors();
                    }
                });
            }
        };

        public Constructor<?>[] getDeclaredConstructors(Class<?> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetContextClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        public static GetContextClassLoaderAction INSTANCE = new GetContextClassLoaderAction();

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    static interface CtClassDebugWriteFileAction {
        public static final CtClassDebugWriteFileAction PRIVILEGED = new CtClassDebugWriteFileAction(){

            public void debugWriteFile(final CtClass ctClass) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            ctClass.debugWriteFile();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    // empty catch block
                }
            }
        };
        public static final CtClassDebugWriteFileAction NON_PRIVILEGED = new CtClassDebugWriteFileAction(){

            public void debugWriteFile(CtClass ctClass) {
                ctClass.debugWriteFile();
            }
        };

        public void debugWriteFile(CtClass var1);
    }

    static interface SetAccessibleAction {
        public static final SetAccessibleAction PRIVILEGED = new SetAccessibleAction(){

            public void setAccessible(final AccessibleObject accessibleObject) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            accessibleObject.setAccessible(true);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException("Error setting " + accessibleObject + " as accessible ", e.getException());
                }
            }
        };
        public static final SetAccessibleAction NON_PRIVILEGED = new SetAccessibleAction(){

            public void setAccessible(AccessibleObject accessibleObject) {
                accessibleObject.setAccessible(true);
            }
        };

        public void setAccessible(AccessibleObject var1);
    }
}

