/*
 * Decompiled with CFR 0.152.
 */
package hidden.de.zeigermann.xml.simpleImporter;

public class ConversionHelpers {
    public static String getString(String value, String fallBack) {
        if (value == null) {
            return fallBack;
        }
        return value;
    }

    public static int getInt(String value) {
        return ConversionHelpers.getInt(value, -1);
    }

    public static int getInt(String value, int fallBack) {
        if (value == null) {
            return fallBack;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            return fallBack;
        }
    }

    public static long getLong(String value) {
        return ConversionHelpers.getLong(value, -1L);
    }

    public static long getLong(String value, long fallBack) {
        if (value == null) {
            return fallBack;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            return fallBack;
        }
    }

    public static boolean getBoolean(String value, boolean fallBack) {
        if (value == null) {
            return fallBack;
        }
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        return fallBack;
    }
}

