/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.AbstractArtifactWithRepositoryTask;
import org.apache.maven.artifact.ant.AntResolutionListener;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.resolver.filter.TypeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class DependenciesTask
extends AbstractArtifactWithRepositoryTask {
    private List dependencies = new ArrayList();
    private String pathId;
    private String filesetId;
    private String sourcesFilesetId;
    private String javadocFilesetId;
    private String versionsId;
    private String useScope;
    private String type;
    private boolean verbose;
    static /* synthetic */ Class class$org$apache$maven$artifact$ant$DependenciesTask;

    protected void doExecute() {
        ArtifactResolutionResult result;
        this.showVersion();
        ArtifactRepository localRepo = this.createLocalArtifactRepository();
        this.log("Using local repository: " + localRepo.getBasedir(), 3);
        ArtifactResolver resolver = (ArtifactResolver)this.lookup(ArtifactResolver.ROLE);
        ArtifactFactory artifactFactory = (ArtifactFactory)this.lookup(ArtifactFactory.ROLE);
        MavenMetadataSource metadataSource = (MavenMetadataSource)this.lookup(ArtifactMetadataSource.ROLE);
        List dependencies = this.dependencies;
        Pom pom = this.buildPom(localRepo);
        if (pom != null) {
            if (!dependencies.isEmpty()) {
                throw new BuildException("You cannot specify both dependencies and a pom in the dependencies task");
            }
            dependencies = pom.getDependencies();
        } else {
            pom = this.createDummyPom(localRepo);
        }
        if (dependencies.isEmpty()) {
            this.log("There were no dependencies specified", 1);
        }
        this.log("Resolving dependencies...", 3);
        List remoteArtifactRepositories = this.createRemoteArtifactRepositories(pom.getRepositories());
        try {
            Set artifacts = MavenMetadataSource.createArtifacts(artifactFactory, dependencies, null, null, null);
            Artifact pomArtifact = artifactFactory.createBuildArtifact(pom.getGroupId(), pom.getArtifactId(), pom.getVersion(), pom.getPackaging());
            List<AntResolutionListener> listeners = Collections.singletonList(new AntResolutionListener(this.getProject(), this.verbose));
            Map managedDependencies = Collections.EMPTY_MAP;
            ArtifactFilter filter = null;
            if (this.useScope != null) {
                filter = new ScopeArtifactFilter(this.useScope);
            }
            if (this.type != null) {
                TypeArtifactFilter typeArtifactFilter = new TypeArtifactFilter(this.type);
                if (filter != null) {
                    AndArtifactFilter andFilter = new AndArtifactFilter();
                    andFilter.add(filter);
                    andFilter.add(typeArtifactFilter);
                    filter = andFilter;
                } else {
                    filter = typeArtifactFilter;
                }
            }
            result = resolver.resolveTransitively(artifacts, pomArtifact, managedDependencies, localRepo, remoteArtifactRepositories, metadataSource, filter, listeners);
        }
        catch (ArtifactResolutionException e) {
            throw new BuildException("Unable to resolve artifact: " + e.getMessage(), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new BuildException("Dependency not found: " + e.getMessage(), (Throwable)e);
        }
        catch (InvalidDependencyVersionException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        FileList fileList = new FileList();
        fileList.setDir(this.getLocalRepository().getPath());
        FileSet fileSet = new FileSet();
        fileSet.setProject(this.getProject());
        fileSet.setDir(fileList.getDir(this.getProject()));
        FileSet sourcesFileSet = new FileSet();
        sourcesFileSet.setDir(this.getLocalRepository().getPath());
        FileSet javadocsFileSet = new FileSet();
        javadocsFileSet.setDir(this.getLocalRepository().getPath());
        HashSet<String> versions = new HashSet<String>();
        Iterator i = result.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.addArtifactToResult(localRepo, artifact, fileSet, fileList);
            versions.add(artifact.getVersion());
            if (this.sourcesFilesetId != null) {
                this.resolveSource(artifactFactory, resolver, remoteArtifactRepositories, localRepo, artifact, "sources", sourcesFileSet);
            }
            if (this.javadocFilesetId == null) continue;
            this.resolveSource(artifactFactory, resolver, remoteArtifactRepositories, localRepo, artifact, "javadoc", javadocsFileSet);
        }
        if (this.pathId != null) {
            Path path = new Path(this.getProject());
            if (versions.size() > 0) {
                path.addFilelist(fileList);
            }
            this.getProject().addReference(this.pathId, (Object)path);
        }
        this.defineFilesetReference(this.filesetId, fileSet);
        this.defineFilesetReference(this.sourcesFilesetId, sourcesFileSet);
        this.defineFilesetReference(this.javadocFilesetId, javadocsFileSet);
        if (this.versionsId != null) {
            String versionsValue = StringUtils.join(versions.iterator(), File.pathSeparator);
            this.getProject().setNewProperty(this.versionsId, versionsValue);
        }
    }

    private void defineFilesetReference(String id, FileSet fileSet) {
        if (id != null) {
            if (!fileSet.hasPatterns()) {
                fileSet.createExclude().setName("**/**");
            }
            this.getProject().addReference(id, (Object)fileSet);
        }
    }

    private void addArtifactToResult(ArtifactRepository localRepo, Artifact artifact, FileSet toFileSet) {
        this.addArtifactToResult(localRepo, artifact, toFileSet, null);
    }

    private void addArtifactToResult(ArtifactRepository localRepo, Artifact artifact, FileSet toFileSet, FileList toFileList) {
        String filename = localRepo.pathOf(artifact);
        toFileSet.createInclude().setName(filename);
        if (toFileList != null) {
            FileList.FileName file = new FileList.FileName();
            file.setName(filename);
            toFileList.addConfiguredFile(file);
        }
        this.getProject().setProperty(artifact.getDependencyConflictId(), artifact.getFile().getAbsolutePath());
    }

    private void resolveSource(ArtifactFactory artifactFactory, ArtifactResolver resolver, List remoteArtifactRepositories, ArtifactRepository localRepo, Artifact artifact, String classifier, FileSet sourcesFileSet) {
        Artifact sourceArtifact = artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "java-source", classifier);
        try {
            resolver.resolve(sourceArtifact, remoteArtifactRepositories, localRepo);
            this.addArtifactToResult(localRepo, sourceArtifact, sourcesFileSet);
        }
        catch (ArtifactResolutionException e) {
            throw new BuildException("Unable to resolve artifact: " + e.getMessage(), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            // empty catch block
        }
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public String getPathId() {
        return this.pathId;
    }

    public void setPathId(String pathId) {
        this.pathId = pathId;
    }

    public String getFilesetId() {
        return this.filesetId;
    }

    public void setSourcesFilesetId(String filesetId) {
        this.sourcesFilesetId = filesetId;
    }

    public String getSourcesFilesetId() {
        return this.sourcesFilesetId;
    }

    public void setJavadocFilesetId(String filesetId) {
        this.javadocFilesetId = filesetId;
    }

    public String getJavadocFilesetId() {
        return this.javadocFilesetId;
    }

    public void setFilesetId(String filesetId) {
        this.filesetId = filesetId;
    }

    public String getVersionsId() {
        return this.versionsId;
    }

    public void setVersionsId(String versionsId) {
        this.versionsId = versionsId;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setUseScope(String useScope) {
        this.useScope = useScope;
    }

    public void setType(String type) {
        this.type = type;
    }

    private void showVersion() {
        try {
            Properties properties = new Properties();
            InputStream resourceAsStream = (class$org$apache$maven$artifact$ant$DependenciesTask == null ? (class$org$apache$maven$artifact$ant$DependenciesTask = DependenciesTask.class$("org.apache.maven.artifact.ant.DependenciesTask")) : class$org$apache$maven$artifact$ant$DependenciesTask).getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven/maven-ant-tasks/pom.properties");
            if (resourceAsStream != null) {
                properties.load(resourceAsStream);
            }
            String version = properties.getProperty("version", "unknown");
            String builtOn = properties.getProperty("builtOn");
            if (builtOn != null) {
                this.log("Maven Ant Tasks version: " + version + " built on " + builtOn, 3);
            } else {
                this.log("Maven Ant Tasks version: " + version, 3);
            }
        }
        catch (IOException e) {
            this.log("Unable to determine version from Maven Ant Tasks JAR file: " + e.getMessage(), 1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

