/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.delegate.CreateConnectionResult;
import org.jboss.jms.server.endpoint.advised.ConnectionFactoryAdvised;
import org.jboss.jms.wireformat.CallbackRequestSupport;
import org.jboss.jms.wireformat.ConnectionFactoryCreateConnectionDelegateResponse;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.ResponseSupport;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;

public class ConnectionFactoryCreateConnectionDelegateRequest
extends CallbackRequestSupport {
    private String username;
    private String password;
    private int failedNodeId;
    private transient ServerInvokerCallbackHandler callbackHandler;

    public ConnectionFactoryCreateConnectionDelegateRequest() {
    }

    public ConnectionFactoryCreateConnectionDelegateRequest(String objectId, byte version, String remotingSessionId, String clientVMId, String username, String password, int failedNodeId) {
        super(clientVMId, remotingSessionId, objectId, 100, version);
        this.username = username;
        this.password = password;
        this.failedNodeId = failedNodeId;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        this.username = this.readNullableString(is);
        this.password = this.readNullableString(is);
        this.failedNodeId = is.readInt();
    }

    public ResponseSupport serverInvoke() throws Exception {
        ConnectionFactoryAdvised advised = (ConnectionFactoryAdvised)Dispatcher.instance.getTarget(this.objectId);
        if (advised == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        CreateConnectionResult del = advised.createConnectionDelegate(this.username, this.password, this.failedNodeId, this.getRemotingSessionID(), this.getClientVMID(), this.version, this.callbackHandler);
        return new ConnectionFactoryCreateConnectionDelegateResponse(del);
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        this.writeNullableString(this.username, os);
        this.writeNullableString(this.password, os);
        os.writeInt(this.failedNodeId);
        os.flush();
    }

    public ServerInvokerCallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(ServerInvokerCallbackHandler handler) {
        this.callbackHandler = handler;
    }
}

