/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.orbspecific.coordinator;

import com.arjuna.ArjunaOTS.ActionControl;
import com.arjuna.ArjunaOTS.ActionControlHelper;
import com.arjuna.ArjunaOTS.ActiveThreads;
import com.arjuna.ArjunaOTS.ActiveTransaction;
import com.arjuna.ArjunaOTS.ArjunaSubtranAwareResource;
import com.arjuna.ArjunaOTS.ArjunaSubtranAwareResourceHelper;
import com.arjuna.ArjunaOTS.ArjunaTransactionOperations;
import com.arjuna.ArjunaOTS.BadControl;
import com.arjuna.ArjunaOTS.Destroyed;
import com.arjuna.ArjunaOTS.JTAInterposedSynchronizationHelper;
import com.arjuna.ArjunaOTS.ManagedSynchronization;
import com.arjuna.ArjunaOTS.ManagedSynchronizationHelper;
import com.arjuna.ArjunaOTS.OTSAbstractRecord;
import com.arjuna.ArjunaOTS.OTSAbstractRecordHelper;
import com.arjuna.ArjunaOTS.UidCoordinator;
import com.arjuna.ArjunaOTS.UidCoordinatorHelper;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.CheckedAction;
import com.arjuna.ats.arjuna.coordinator.TransactionReaper;
import com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.OTSImpleManager;
import com.arjuna.ats.internal.jts.coordinator.CheckedActions;
import com.arjuna.ats.internal.jts.orbspecific.ControlImple;
import com.arjuna.ats.internal.jts.orbspecific.TransactionFactoryImple;
import com.arjuna.ats.internal.jts.recovery.RecoveryCreator;
import com.arjuna.ats.internal.jts.resources.ExtendedResourceRecord;
import com.arjuna.ats.internal.jts.resources.ResourceRecord;
import com.arjuna.ats.internal.jts.resources.SynchronizationRecord;
import com.arjuna.ats.internal.jts.utils.Helper;
import com.arjuna.ats.jts.OTSManager;
import com.arjuna.ats.jts.common.jtsPropertyManager;
import com.arjuna.ats.jts.extensions.Arjuna;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionAwareResourceHelper;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.Unavailable;

public class ArjunaTransactionImple
extends TwoPhaseCoordinator
implements ArjunaTransactionOperations {
    protected ArjunaTransactionImple parentTransaction;
    protected ControlImple controlHandle;
    private int hashCode;
    private int topLevelHashCode;
    private Control parentHandle;
    private Status currentStatus;
    private Thread transactionCreator;
    private BasicAction rootAction;
    private SortedSet _synchs;
    private SynchronizationRecord _currentRecord;
    static int _ipType;
    static boolean _subtran;
    static boolean _syncOn;
    static boolean _checkedTransactions;
    static boolean _propagateTerminator;
    static boolean _propagateRemainingTimeout;

    public ArjunaTransactionImple(Control myParent) {
        this(myParent, null);
    }

    public ArjunaTransactionImple(Control myParent, ArjunaTransactionImple parent) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(1L, 4L, 256L, "ArjunaTransactionImple Begin for < " + this.get_uid() + " , " + (parent != null ? parent.get_uid() : Uid.nullUid()) + " >");
        }
        this.parentTransaction = parent;
        this.controlHandle = null;
        this.parentHandle = myParent;
        this.currentStatus = Status.StatusUnknown;
        this.rootAction = null;
        this._synchs = null;
        super.Begin((BasicAction)parent);
        if (parent != null) {
            parent.addChildAction((BasicAction)this);
        }
        this.currentStatus = this.determineStatus((BasicAction)this);
        this.rootAction = this;
        this.hashCode = this.get_uid().hashCode();
        if (parent != null) {
            while (this.rootAction.parent() != null) {
                this.rootAction = this.rootAction.parent();
            }
            this.topLevelHashCode = this.rootAction.get_uid().hashCode();
        } else {
            this.topLevelHashCode = this.hashCode;
        }
        this.transactionCreator = _checkedTransactions ? Thread.currentThread() : null;
        CheckedAction ca = CheckedActions.get();
        if (ca != null) {
            super.setCheckedAction(ca);
            ca = null;
        }
    }

    public ArjunaTransactionImple(Uid actUid, Control myParent) {
        this(actUid, myParent, null);
    }

    public ArjunaTransactionImple(Uid actUid, Control myParent, ArjunaTransactionImple parent) {
        super(actUid);
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(1L, 4L, 256L, "ArjunaTransactionImple Begin for < " + this.get_uid() + " , " + (parent != null ? parent.get_uid() : Uid.nullUid()) + " >");
        }
        this.parentTransaction = parent;
        this.controlHandle = null;
        this.parentHandle = myParent;
        this.currentStatus = Status.StatusUnknown;
        this.rootAction = null;
        this._synchs = null;
        super.Begin((BasicAction)parent);
        if (parent != null) {
            parent.addChildAction((BasicAction)this);
        }
        this.currentStatus = this.determineStatus((BasicAction)this);
        this.rootAction = this;
        this.hashCode = this.get_uid().hashCode();
        if (parent != null) {
            while (this.rootAction.parent() != null) {
                this.rootAction = this.rootAction.parent();
            }
            this.topLevelHashCode = this.rootAction.get_uid().hashCode();
        } else {
            this.topLevelHashCode = this.hashCode;
        }
        this.transactionCreator = _checkedTransactions ? Thread.currentThread() : null;
        CheckedAction ca = CheckedActions.get();
        if (ca != null) {
            super.setCheckedAction(ca);
            ca = null;
        }
    }

    public void finalize() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(2L, 4L, 256L, "ArjunaTransactionImple.finalize - called for < " + this.get_uid() + " >");
        }
        if (this._synchs != null) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.coordinator.szync", new Object[]{"ArjunaTransactionImple.finalize()"});
            }
            this._synchs = null;
        }
        this.controlHandle = null;
        super.finalize();
    }

    public final synchronized ControlImple getControlHandle() {
        return this.controlHandle;
    }

    public final synchronized void setControlHandle(ControlImple handle) {
        this.controlHandle = handle;
    }

    @Override
    public void commit(boolean report_heuristics) throws HeuristicMixed, HeuristicHazard, SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::commit for " + this.get_uid());
        }
        if (_checkedTransactions && !this.checkAccess()) {
            throw new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
        }
        int outcome = super.status();
        if (outcome == 0 || outcome == 3) {
            try {
                if (this._synchs != null && (outcome == 0 || outcome == 3 && TxControl.isBeforeCompletionWhenRollbackOnly())) {
                    this.doBeforeCompletion();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.parentTransaction != null) {
                this.parentTransaction.removeChildAction((BasicAction)this);
            }
            outcome = super.End(report_heuristics);
            try {
                if (this._synchs != null) {
                    this.currentStatus = this.determineStatus((BasicAction)this);
                    this.doAfterCompletion(this.currentStatus);
                    this._synchs = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } else {
            throw new INVALID_TRANSACTION(0, CompletionStatus.COMPLETED_NO);
        }
        this.destroyAction();
        switch (outcome) {
            case 6: 
            case 7: 
            case 12: {
                return;
            }
            case 2: 
            case 4: 
            case 11: {
                throw new TRANSACTION_ROLLEDBACK(50001, CompletionStatus.COMPLETED_NO);
            }
            case 13: {
                throw new HeuristicMixed();
            }
        }
        throw new HeuristicHazard();
    }

    @Override
    public void rollback() throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::rollback for " + this.get_uid());
        }
        if (_checkedTransactions && !this.checkAccess()) {
            throw new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
        }
        int status = super.status();
        if (status == 0 || status == 3) {
            if (_syncOn) {
                if (TxControl.isBeforeCompletionWhenRollbackOnly()) {
                    try {
                        if (this._synchs != null) {
                            this.doBeforeCompletion();
                        }
                    }
                    catch (Exception e) {}
                }
            } else {
                this._synchs = null;
            }
            if (this.parentTransaction != null) {
                this.parentTransaction.removeChildAction((BasicAction)this);
            }
            super.Abort();
            if (_syncOn) {
                try {
                    if (this._synchs != null) {
                        this.currentStatus = this.determineStatus((BasicAction)this);
                        this.doAfterCompletion(this.currentStatus);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            throw new INVALID_TRANSACTION(0, CompletionStatus.COMPLETED_NO);
        }
        this.destroyAction();
        status = super.status();
        switch (status) {
            case 2: 
            case 4: 
            case 11: {
                return;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: {
                throw new INVALID_TRANSACTION(0, CompletionStatus.COMPLETED_NO);
            }
            case 9: 
            case 10: {
                throw new UNKNOWN(30001, CompletionStatus.COMPLETED_MAYBE);
            }
        }
    }

    @Override
    public Status get_status() throws SystemException {
        Status s = this.determineStatus((BasicAction)this);
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::get_status for " + this.get_uid() + " returning " + Utility.stringStatus((Status)s));
        }
        return s;
    }

    @Override
    public Status get_parent_status() throws SystemException {
        if (this.parentTransaction != null) {
            return this.parentTransaction.get_status();
        }
        return this.get_status();
    }

    @Override
    public Status get_top_level_status() throws SystemException {
        if (this.rootAction != null) {
            return this.determineStatus(this.rootAction);
        }
        return this.get_status();
    }

    @Override
    public boolean is_same_transaction(Coordinator tc) throws SystemException {
        if (tc == null) {
            return false;
        }
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::is_same_transaction comparing hash codes: < " + tc.hash_transaction() + ", " + this.hash_transaction() + " >");
        }
        if (tc.hash_transaction() != this.hash_transaction()) {
            return false;
        }
        boolean result = false;
        try {
            String compareUid;
            String myUid;
            UidCoordinator ptr = UidCoordinatorHelper.narrow(tc);
            if (ptr != null) {
                myUid = this.uid();
                compareUid = ptr.uid();
                if (jtsLogger.logger.isDebugEnabled()) {
                    jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::is_same_transaction comparing uids < " + compareUid + ", " + myUid + " >");
                }
                if (myUid.compareTo(compareUid) == 0) {
                    result = true;
                }
            } else {
                throw new BAD_PARAM();
            }
            myUid = null;
            compareUid = null;
            ptr = null;
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public boolean is_related_transaction(Coordinator tc) throws SystemException {
        if (tc == null) {
            return false;
        }
        boolean result = false;
        try {
            String compareTLUid;
            String myTLUid;
            UidCoordinator ptr = UidCoordinatorHelper.narrow(tc);
            if (ptr != null) {
                myTLUid = this.topLevelUid();
                compareTLUid = ptr.topLevelUid();
                if (jtsLogger.logger.isDebugEnabled()) {
                    jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::is_related_transaction comparing uids < " + compareTLUid + ", " + myTLUid + " >");
                }
                if (myTLUid.compareTo(compareTLUid) == 0) {
                    result = true;
                }
            } else {
                throw new BAD_PARAM();
            }
            myTLUid = null;
            compareTLUid = null;
            ptr = null;
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public boolean is_ancestor_transaction(Coordinator tc) throws SystemException {
        if (tc == null) {
            return false;
        }
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::is_ancestor_transaction ()");
        }
        if (this.is_same_transaction(tc)) {
            return true;
        }
        if (this.is_related_transaction(tc)) {
            return !this.is_descendant_transaction(tc);
        }
        return false;
    }

    @Override
    public boolean is_descendant_transaction(Coordinator tc) throws SystemException {
        if (tc == null) {
            return false;
        }
        try {
            UidCoordinator ptr = UidCoordinatorHelper.narrow(tc);
            if (ptr != null) {
                Uid lookingFor = new Uid(ptr.uid());
                ArjunaTransactionImple lookingAt = this;
                if (jtsLogger.logger.isDebugEnabled()) {
                    jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::is_descendant_transaction - looking for " + lookingFor);
                }
                while (lookingAt != null) {
                    if (jtsLogger.logger.isDebugEnabled()) {
                        jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::is_descendant_transaction - looking for " + lookingAt.get_uid());
                    }
                    if (lookingAt.get_uid().equals(lookingFor)) {
                        return true;
                    }
                    lookingAt = lookingAt.parent();
                }
            } else {
                throw new BAD_PARAM();
            }
            ptr = null;
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean is_top_level_transaction() throws SystemException {
        return this == this.rootAction;
    }

    @Override
    public int hash_transaction() throws SystemException {
        return this.hashCode;
    }

    @Override
    public int hash_top_level_tran() throws SystemException {
        return this.topLevelHashCode;
    }

    @Override
    public RecoveryCoordinator register_resource(Resource r) throws SystemException, Inactive {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::register_resource ( " + r + " ) - called for " + this.get_uid());
        }
        if (r == null) {
            throw new BAD_PARAM(0, CompletionStatus.COMPLETED_NO);
        }
        this.currentStatus = this.determineStatus((BasicAction)this);
        if (this.currentStatus != Status.StatusActive) {
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::register_resource - transaction not active: " + Utility.stringStatus((Status)this.currentStatus));
            }
            if (this.currentStatus == Status.StatusMarkedRollback) {
                throw new TRANSACTION_ROLLEDBACK(50003, CompletionStatus.COMPLETED_NO);
            }
            throw new Inactive();
        }
        AbstractRecord corbaRec = null;
        ArjunaTransactionImple registerIn = this;
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple " + this.get_uid() + " ::register_resource: ");
        }
        int index = 0;
        Object[] params = new Object[10];
        params[index++] = this;
        RecoveryCoordinator recoveryCoordinator = null;
        Uid recoveryCoordinatorUid = null;
        try {
            recoveryCoordinator = RecoveryCreator.createRecoveryCoordinator((Resource)r, (Object[])params);
            if (recoveryCoordinator == null) {
                throw new BAD_OPERATION("RecoveryCoordinator " + jtsLogger.logMesg.getString("com.arjuna.ats.internal.jts.orbspecific.coordinator.rcnotcreated"));
            }
        }
        catch (NO_IMPLEMENT ex) {
            recoveryCoordinator = null;
        }
        catch (SystemException e) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.coordinator.rccreate", new Object[]{this.get_uid(), e});
            }
            try {
                this.rollback_only();
            }
            catch (Inactive ex1) {
            }
            catch (SystemException ex2) {
                if (jtsLogger.loggerI18N.isWarnEnabled()) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.coordinator.rbofail", new Object[]{"ArjunaTransactionImple.register_resource", this.get_uid(), ex2});
                }
                throw ex2;
            }
            throw e;
        }
        if (recoveryCoordinator != null) {
            index = 0;
            recoveryCoordinatorUid = (Uid)params[index++];
        } else {
            recoveryCoordinatorUid = Uid.nullUid();
        }
        try {
            Coordinator coord;
            SubtransactionAwareResource staResource = SubtransactionAwareResourceHelper.narrow(r);
            if (staResource != null) {
                if (jtsLogger.logger.isDebugEnabled()) {
                    jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::register_resource for " + this.get_uid() + " - subtransaction aware resource: YES");
                }
                coord = null;
                if (this.parentHandle != null) {
                    coord = this.parentHandle.get_coordinator();
                }
            } else {
                throw new BAD_PARAM(0, CompletionStatus.COMPLETED_NO);
            }
            corbaRec = this.createOTSRecord(true, r, coord, recoveryCoordinatorUid);
            coord = null;
            staResource = null;
        }
        catch (BAD_PARAM ex) {
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::register_resource for " + this.get_uid() + " - subtransaction aware resource: NO");
            }
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple " + this.get_uid() + " ::register_resource: Simple resource - " + (Object)((Object)ex));
            }
            corbaRec = this.createOTSRecord(true, r, null, recoveryCoordinatorUid);
        }
        catch (Unavailable e1) {
            throw new Inactive();
        }
        catch (SystemException e2) {
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::register_resource for " + this.get_uid() + " : catch (SystemException) - " + (Object)((Object)e2));
            }
            throw e2;
        }
        catch (Exception e3) {
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::register_resource for " + this.get_uid() + " : catch (...) - " + e3);
            }
            throw new UNKNOWN(e3.toString(), 30001, CompletionStatus.COMPLETED_NO);
        }
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::register_resource for " + this.get_uid() + " : try end");
        }
        if (registerIn.add(corbaRec) != 2) {
            corbaRec = null;
            throw new INVALID_TRANSACTION(60004, CompletionStatus.COMPLETED_NO);
        }
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::register_resource for " + this.get_uid() + " : resource registered");
        }
        return recoveryCoordinator;
    }

    @Override
    public void register_subtran_aware(SubtransactionAwareResource r) throws Inactive, NotSubtransaction, SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::register_subtran_aware called for " + this.get_uid());
        }
        if (r == null) {
            throw new BAD_PARAM(0, CompletionStatus.COMPLETED_NO);
        }
        this.currentStatus = this.determineStatus((BasicAction)this);
        if (this.currentStatus != Status.StatusActive) {
            if (this.currentStatus == Status.StatusMarkedRollback) {
                throw new TRANSACTION_ROLLEDBACK(50003, CompletionStatus.COMPLETED_NO);
            }
            throw new Inactive();
        }
        if (this == this.rootAction) {
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::register_subtran_aware called for " + this.get_uid() + " : not a subtransaction!");
            }
            throw new NotSubtransaction();
        }
        Coordinator coord = null;
        AbstractRecord corbaRec = null;
        try {
            coord = this.parentHandle.get_coordinator();
            corbaRec = this.createOTSRecord(false, r, coord);
        }
        catch (Unavailable ex) {
            throw new UNKNOWN(20001, CompletionStatus.COMPLETED_NO);
        }
        coord = null;
        if (this.add(corbaRec) != 2) {
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::register_subtran_aware called for " + this.get_uid() + " : could not add.");
            }
            corbaRec = null;
            throw new Inactive();
        }
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::register_subtran_aware called for " + this.get_uid() + " : subtran_aware_resource registered");
        }
    }

    @Override
    public void rollback_only() throws SystemException, Inactive {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::rollback_only - called for " + this.get_uid());
        }
        if (this.determineStatus((BasicAction)this) != Status.StatusPrepared) {
            if (!this.preventCommit()) {
                throw new INVALID_TRANSACTION(20001, CompletionStatus.COMPLETED_NO);
            }
        } else {
            throw new Inactive();
        }
    }

    @Override
    public String get_transaction_name() throws SystemException {
        return this.get_uid().stringForm();
    }

    @Override
    public Control create_subtransaction() throws SystemException, SubtransactionsUnavailable, Inactive {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::create_subtransaction - called for " + this.get_uid());
        }
        if (this.determineStatus((BasicAction)this) != Status.StatusActive) {
            throw new Inactive();
        }
        if (!_subtran) {
            throw new SubtransactionsUnavailable();
        }
        if (this.controlHandle == null) {
            throw new Inactive();
        }
        return TransactionFactoryImple.create_subtransaction(this.controlHandle.getControl(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register_synchronization(Synchronization sync) throws Inactive, SynchronizationUnavailable, SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::register_synchronization - called for " + this.get_uid());
        }
        if (sync == null) {
            throw new BAD_PARAM(0, CompletionStatus.COMPLETED_NO);
        }
        if (!this.is_top_level_transaction()) {
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::register_synchronization - " + this.get_uid() + " is not a top-level transaction!");
            }
            throw new SynchronizationUnavailable();
        }
        this.currentStatus = this.determineStatus((BasicAction)this);
        if (this.currentStatus == Status.StatusActive) {
            SynchronizationRecord c;
            ArjunaTransactionImple arjunaTransactionImple = this;
            synchronized (arjunaTransactionImple) {
                if (this._synchs == null) {
                    this._synchs = new TreeSet();
                }
            }
            SynchronizationRecord otsSync = sync._is_a(JTAInterposedSynchronizationHelper.id()) ? new SynchronizationRecord(sync, true) : new SynchronizationRecord(sync);
            if (this._currentRecord != null && (c = otsSync).compareTo(this._currentRecord) != 1) {
                throw new UNKNOWN(60004, CompletionStatus.COMPLETED_NO);
            }
            if (!this._synchs.add(otsSync)) {
                otsSync = null;
                throw new UNKNOWN(60004, CompletionStatus.COMPLETED_NO);
            }
        } else {
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::register_synchronization - " + this.get_uid() + " is not active: " + Utility.stringStatus((Status)this.currentStatus));
            }
            if (this.currentStatus == Status.StatusMarkedRollback) {
                throw new TRANSACTION_ROLLEDBACK(50003, CompletionStatus.COMPLETED_NO);
            }
            throw new Inactive();
        }
    }

    @Override
    public PropagationContext get_txcontext() throws Unavailable, SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple::get_txcontext - called for " + this.get_uid());
        }
        this.currentStatus = this.determineStatus((BasicAction)this);
        if (this.currentStatus != Status.StatusActive && this.currentStatus != Status.StatusMarkedRollback) {
            throw new Unavailable();
        }
        try {
            return this.propagationContext();
        }
        catch (Exception e) {
            throw new Unavailable();
        }
    }

    @Override
    public String uid() throws SystemException {
        return this.get_uid().stringForm();
    }

    @Override
    public String topLevelUid() throws SystemException {
        if (this.rootAction != null) {
            return this.rootAction.get_uid().stringForm();
        }
        return null;
    }

    public String type() {
        return ArjunaTransactionImple.typeName();
    }

    public static final int interpositionType() {
        return _ipType;
    }

    public static String typeName() {
        return "/StateManager/BasicAction/TwoPhaseCoordinator/ArjunaTransactionImple";
    }

    public String toString() {
        return "ArjunaTransactionImple < " + this.get_uid() + " >";
    }

    public boolean equals(Object o) {
        if (o instanceof ArjunaTransactionImple) {
            ArjunaTransactionImple tx = (ArjunaTransactionImple)o;
            if (tx == this) {
                return true;
            }
            return tx.get_uid().equals(this.get_uid());
        }
        return false;
    }

    public boolean forgetHeuristics() {
        return super.forgetHeuristics();
    }

    protected ArjunaTransactionImple(Uid actUid) {
        super(actUid);
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(1L, 2L, 256L, "ArjunaTransactionImple::ArjunaTransactionImple ( " + actUid + " )");
        }
        this.parentTransaction = null;
        this.controlHandle = null;
        this.parentHandle = null;
        this.currentStatus = Status.StatusUnknown;
        this.transactionCreator = null;
        this.rootAction = null;
        this._synchs = null;
        this.rootAction = this;
        this.topLevelHashCode = this.hashCode = actUid.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBeforeCompletion() throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 2L, 256L, "ArjunaTransactionImple::doBeforeCompletion for " + this.get_uid());
        }
        boolean problem = false;
        SystemException exp = null;
        if (this._synchs != null) {
            boolean doSuspend = false;
            ControlWrapper cw = null;
            try {
                try {
                    cw = OTSImpleManager.current().getControlWrapper();
                    if (cw == null || !this.controlHandle.equals(cw.getImple())) {
                        OTSImpleManager.current().resumeImple(this.controlHandle);
                        doSuspend = true;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                int lastIndexProcessed = -1;
                SynchronizationRecord[] copiedSynchs = this._synchs.toArray(new SynchronizationRecord[0]);
                while (lastIndexProcessed < this._synchs.size() - 1 && !problem) {
                    if (copiedSynchs.length != this._synchs.size()) {
                        copiedSynchs = this._synchs.toArray(new SynchronizationRecord[0]);
                    }
                    this._currentRecord = copiedSynchs[++lastIndexProcessed];
                    Synchronization c = this._currentRecord.contents();
                    c.before_completion();
                }
            }
            catch (SystemException e) {
                if (jtsLogger.loggerI18N.isWarnEnabled()) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.coordinator.generror", new Object[]{"ArjunaTransactionImple.doBeforeCompletion", e});
                }
                if (!problem) {
                    exp = e;
                    problem = true;
                    try {
                        this.rollback_only();
                    }
                    catch (Inactive ex) {
                        if (jtsLogger.loggerI18N.isWarnEnabled()) {
                            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.coordinator.rbofail", new Object[]{"ArjunaTransactionImple.doBeforeCompletion", this.get_uid(), ex});
                        }
                    }
                }
            }
            finally {
                if (doSuspend) {
                    try {
                        if (cw != null) {
                            OTSImpleManager.current().resumeWrapper(cw);
                        } else {
                            OTSImpleManager.current().suspend();
                        }
                    }
                    catch (Exception ex) {}
                }
            }
        }
        if (problem) {
            if (exp != null) {
                throw exp;
            }
            throw new UNKNOWN(30004, CompletionStatus.COMPLETED_NO);
        }
    }

    protected void doAfterCompletion(Status myStatus) throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 2L, 256L, "ArjunaTransactionImple::doAfterCompletion for " + this.get_uid());
        }
        if (myStatus == Status.StatusActive) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.coordinator.txrun", new Object[]{"ArjunaTransactionImple.doAfterCompletion"});
            }
            return;
        }
        boolean problem = false;
        SystemException exp = null;
        if (this._synchs != null) {
            ControlWrapper cw = null;
            boolean doSuspend = false;
            try {
                cw = OTSImpleManager.current().getControlWrapper();
                if (cw == null || !this.controlHandle.equals(cw.getImple())) {
                    OTSImpleManager.current().resumeImple(this.controlHandle);
                    doSuspend = true;
                }
            }
            catch (Exception ex) {
                problem = true;
            }
            Stack stack = new Stack();
            Iterator iterator = this._synchs.iterator();
            while (iterator.hasNext()) {
                stack.push(iterator.next());
            }
            iterator = stack.iterator();
            while (!stack.isEmpty()) {
                SynchronizationRecord value = (SynchronizationRecord)stack.pop();
                Synchronization c = value.contents();
                try {
                    c.after_completion(myStatus);
                }
                catch (SystemException e) {
                    if (jtsLogger.logger.isDebugEnabled()) {
                        jtsLogger.logger.debug(16L, 4L, 256L, "ArjunaTransactionImple.doAfterCompletion - caught exception " + (Object)((Object)e));
                    }
                    problem = true;
                    if (exp != null) continue;
                    exp = e;
                }
            }
            if (doSuspend) {
                try {
                    if (cw != null) {
                        OTSImpleManager.current().resumeWrapper(cw);
                    } else {
                        OTSImpleManager.current().suspend();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this._synchs = null;
        }
        if (problem) {
            if (exp != null) {
                throw exp;
            }
            throw new UNKNOWN(30004, CompletionStatus.COMPLETED_NO);
        }
    }

    final void forceRollback() throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 8L, 256L, "ArjunaTransactionImple::forceRollback for " + this.get_uid());
        }
        if (super.status() == 0) {
            if (_syncOn) {
                if (TxControl.isBeforeCompletionWhenRollbackOnly()) {
                    try {
                        if (this._synchs != null) {
                            this.doBeforeCompletion();
                        }
                    }
                    catch (Exception e) {}
                }
            } else {
                this._synchs = null;
            }
            if (this.parentTransaction != null) {
                this.parentTransaction.removeChildAction((BasicAction)this);
            }
            this.Abort();
            if (_syncOn) {
                try {
                    if (this._synchs != null) {
                        this.currentStatus = this.determineStatus((BasicAction)this);
                        this.doAfterCompletion(this.currentStatus);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.destroyAction();
        }
    }

    private final Status determineStatus(BasicAction whichAction) {
        Status theStatus = Status.StatusUnknown;
        if (whichAction != null) {
            switch (whichAction.status()) {
                case 9: {
                    theStatus = Status.StatusUnknown;
                    break;
                }
                case 0: {
                    theStatus = Status.StatusActive;
                    break;
                }
                case 5: {
                    theStatus = Status.StatusPrepared;
                    break;
                }
                case 7: 
                case 12: 
                case 13: 
                case 14: {
                    theStatus = Status.StatusCommitted;
                    break;
                }
                case 4: 
                case 11: {
                    theStatus = Status.StatusRolledBack;
                    break;
                }
                case 3: {
                    theStatus = Status.StatusMarkedRollback;
                    break;
                }
                case 1: {
                    theStatus = Status.StatusPreparing;
                    break;
                }
                case 6: {
                    theStatus = Status.StatusCommitting;
                    break;
                }
                case 2: {
                    theStatus = Status.StatusRollingBack;
                    break;
                }
                default: {
                    theStatus = Status.StatusUnknown;
                    break;
                }
            }
        } else {
            theStatus = Status.StatusNoTransaction;
        }
        return theStatus;
    }

    protected final AbstractRecord createOTSRecord(boolean propagate, Resource resource, Coordinator coord) {
        return this.createOTSRecord(propagate, resource, coord, null);
    }

    protected final AbstractRecord createOTSRecord(boolean propagate, Resource resource, Coordinator coord, Uid recCoordUid) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 2L, 256L, "ArjunaTransactionImple::createOTSRecord for " + this.get_uid());
        }
        ArjunaSubtranAwareResource absRec = null;
        ResourceRecord corbaRec = null;
        if (resource != null) {
            try {
                absRec = ArjunaSubtranAwareResourceHelper.narrow(resource);
                if (absRec == null) {
                    throw new BAD_PARAM(0, CompletionStatus.COMPLETED_NO);
                }
            }
            catch (Exception e) {
                absRec = null;
            }
        }
        if (absRec == null) {
            corbaRec = new ResourceRecord(propagate, resource, coord, recCoordUid, this);
        } else {
            OTSAbstractRecord otsRec;
            Uid u = null;
            try {
                otsRec = OTSAbstractRecordHelper.narrow(absRec);
                if (otsRec == null) {
                    throw new BAD_PARAM(0, CompletionStatus.COMPLETED_NO);
                }
            }
            catch (Exception e) {
                otsRec = null;
            }
            if (otsRec != null) {
                try {
                    u = new Uid(otsRec.uid());
                }
                catch (Exception e) {
                    u = null;
                }
                if (u == null && jtsLogger.loggerI18N.isWarnEnabled()) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.coordinator.uidfail", new Object[]{"ArjunaTransactionImple.createOTSRecord"});
                }
            }
            if (u == null) {
                u = new Uid();
            }
            corbaRec = new ExtendedResourceRecord(propagate, u, absRec, coord, recCoordUid, this);
            otsRec = null;
            absRec = null;
            u = null;
        }
        return corbaRec;
    }

    private final boolean checkAccess() {
        return Thread.currentThread() == this.transactionCreator;
    }

    private final PropagationContext propagationContext() throws Unavailable, Inactive, SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 1L, 256L, "ArjunaTransactionImple::propagationContext for " + this.get_uid());
        }
        String theUid = null;
        Control currentControl = this.controlHandle.getControl();
        PropagationContext context = new PropagationContext();
        int sequenceThreshold = 1;
        int sequenceIncrement = 5;
        context.parents = null;
        context.current = new TransIdentity();
        context.implementation_specific_data = ORBManager.getORB().orb().create_any();
        context.implementation_specific_data.insert_short((short)0);
        try {
            context.current.coord = this.controlHandle.get_coordinator();
            context.timeout = 0;
            context.current.term = _propagateTerminator ? this.controlHandle.get_terminator() : null;
        }
        catch (Exception e) {
            return null;
        }
        theUid = this.controlHandle.get_uid().stringForm();
        context.current.otid = Utility.uidToOtid((String)theUid);
        context.current.otid.formatID = _ipType;
        int index = 0;
        while (currentControl != null) {
            try {
                ActionControl control = ActionControlHelper.narrow(currentControl);
                if (control != null) {
                    currentControl = control.getParentControl();
                    if (currentControl != null) {
                        if (index == 0) {
                            context.parents = new TransIdentity[sequenceThreshold];
                            for (int ii = 0; ii < sequenceThreshold; ++ii) {
                                context.parents[ii] = null;
                            }
                        }
                        context.parents[index] = new TransIdentity();
                        context.parents[index].coord = currentControl.get_coordinator();
                        context.parents[index].term = _propagateTerminator ? currentControl.get_terminator() : null;
                        UidCoordinator uidCoord = Helper.getUidCoordinator((Coordinator)context.parents[index].coord);
                        theUid = uidCoord.uid();
                        context.parents[index].otid = Utility.uidToOtid((String)theUid);
                        context.parents[index].otid.formatID = _ipType;
                        theUid = null;
                        uidCoord = null;
                        if (++index >= sequenceThreshold) {
                            sequenceThreshold = index + sequenceIncrement;
                            context.parents = this.resizeHierarchy(context.parents, index + sequenceIncrement);
                        }
                    } else if (TransactionReaper.transactionReaper() != null) {
                        if (_propagateRemainingTimeout) {
                            long timeInMills = TransactionReaper.transactionReaper().getRemainingTimeoutMills((Object)control);
                            context.timeout = (int)(timeInMills / 1000L);
                        } else {
                            context.timeout = TransactionReaper.transactionReaper().getTimeout((Object)control);
                        }
                    } else {
                        context.timeout = 0;
                    }
                    control = null;
                    continue;
                }
                throw new BAD_PARAM(0, CompletionStatus.COMPLETED_NO);
            }
            catch (SystemException e) {
                currentControl = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                currentControl = null;
            }
        }
        try {
            context.parents = this.resizeHierarchy(context.parents, index);
        }
        catch (Exception e) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.coordinator.generror", new Object[]{"ArjunaTransactionImple.resizeHierarchy", e});
            }
            context = null;
        }
        return context;
    }

    private final TransIdentity[] resizeHierarchy(TransIdentity[] current, int size) {
        if (current == null || size == 0) {
            return new TransIdentity[0];
        }
        if (current.length == size) {
            return current;
        }
        TransIdentity[] toReturn = new TransIdentity[size];
        int copySize = size < current.length ? size : current.length;
        System.arraycopy(current, 0, toReturn, 0, copySize);
        if (copySize < size) {
            for (int j = copySize; j < size; ++j) {
                toReturn[j] = null;
            }
        }
        return toReturn;
    }

    protected final void destroyAction() {
        block16: {
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug(16L, 2L, 256L, "ArjunaTransactionImple::destroyAction for " + this.get_uid());
            }
            if (this.parentHandle == null) {
                Object[] params = new Object[]{this};
                RecoveryCreator.destroyAllRecoveryCoordinators((Object[])params);
            } else {
                this.parentHandle = null;
            }
            try {
                if (this.controlHandle != null) {
                    OTSManager.destroyControl((ControlImple)this.controlHandle);
                    this.controlHandle = null;
                }
            }
            catch (ActiveThreads ex1) {
                if (jtsLogger.loggerI18N.isWarnEnabled()) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.coordinator.generror", new Object[]{"ArjunaTransactionImple.destroyAction", ex1});
                }
            }
            catch (BadControl ex2) {
                if (jtsLogger.loggerI18N.isWarnEnabled()) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.coordinator.generror", new Object[]{"ArjunaTransactionImple.destroyAction", ex2});
                }
            }
            catch (ActiveTransaction ex3) {
                if (jtsLogger.loggerI18N.isWarnEnabled()) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.coordinator.generror", new Object[]{"ArjunaTransactionImple.destroyAction", ex3});
                }
            }
            catch (Destroyed ex4) {
                if (jtsLogger.loggerI18N.isWarnEnabled()) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.coordinator.generror", new Object[]{"ArjunaTransactionImple.destroyAction", ex4});
                }
            }
            catch (OutOfMemoryError ex5) {
                if (jtsLogger.loggerI18N.isWarnEnabled()) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.coordinator.generror", new Object[]{"ArjunaTransactionImple.destroyAction", ex5});
                }
                System.gc();
            }
            catch (Exception ex6) {
                if (!jtsLogger.loggerI18N.isWarnEnabled()) break block16;
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.coordinator.generror", new Object[]{"ArjunaTransactionImple.destroyAction", ex6});
            }
        }
    }

    public Map<Uid, String> getSynchronizations() {
        if (this._synchs != null) {
            SynchronizationRecord[] synchs;
            HashMap<Uid, String> synchMap = new HashMap<Uid, String>();
            for (SynchronizationRecord synch : synchs = this._synchs.toArray(new SynchronizationRecord[0])) {
                String cn;
                Synchronization c = synch.contents();
                if (c._is_a(ManagedSynchronizationHelper.id())) {
                    ManagedSynchronization mc = ManagedSynchronizationHelper.narrow(c);
                    try {
                        cn = mc.instanceName();
                    }
                    catch (Throwable t) {
                        cn = synch.getClass().getCanonicalName();
                    }
                } else {
                    cn = synch.getClass().getCanonicalName();
                }
                synchMap.put(synch.get_uid(), cn);
            }
            return synchMap;
        }
        return Collections.EMPTY_MAP;
    }

    static {
        String propRemainingTimeout;
        String propTerm;
        String checked;
        String syncOn;
        String supportSubtran;
        _ipType = Arjuna.XID();
        _subtran = true;
        _syncOn = true;
        _checkedTransactions = false;
        _propagateTerminator = false;
        _propagateRemainingTimeout = true;
        String interpositionType = jtsPropertyManager.propertyManager.getProperty("com.arjuna.ats.jts.interposition");
        if (interpositionType != null) {
            int ipType = Arjuna.nameToXID((String)interpositionType);
            if (ipType != -1) {
                _ipType = ipType;
            } else if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.coordinator.ipunknown", new Object[]{"ArjunaTransactionImple.init", interpositionType});
            }
        }
        if ((supportSubtran = jtsPropertyManager.propertyManager.getProperty("com.arjuna.ats.jts.supportSubtransactions")) != null && supportSubtran.compareTo("NO") == 0) {
            _subtran = false;
        }
        if ((syncOn = jtsPropertyManager.propertyManager.getProperty("com.arjuna.ats.jts.supportRollbackSync")) != null && syncOn.compareTo("NO") == 0) {
            _syncOn = false;
        }
        if ((checked = jtsPropertyManager.propertyManager.getProperty("com.arjuna.ats.jts.checkedTransactions")) != null && checked.compareTo("YES") == 0) {
            _checkedTransactions = true;
        }
        if ((propTerm = jtsPropertyManager.propertyManager.getProperty("com.arjuna.ats.jts.propagateTerminator")) != null && propTerm.compareTo("YES") == 0) {
            _propagateTerminator = true;
        }
        if ((propRemainingTimeout = jtsPropertyManager.propertyManager.getProperty("com.arjuna.ats.jts.ots_1_0.timeoutPropagation")) != null && propTerm.compareTo("NO") == 0) {
            _propagateRemainingTimeout = false;
        }
    }
}

