/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.template;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import xdoclet.loader.ModuleFinder;
import xdoclet.loader.TagHandlerDefinition;
import xdoclet.loader.XDocletModule;
import xdoclet.template.PrettyPrintWriter;
import xdoclet.template.TemplateException;
import xdoclet.template.TemplateTagHandler;
import xdoclet.template.XDocletTemplateMessages;
import xdoclet.util.FileManager;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xjavadoc.XJavaDoc;

public class TemplateEngine {
    public static final String TAG_MAPPINGS_FILE = "/tagmappings.properties";
    protected static final String XDOCLET_PREFIX;
    protected static final String XDOCLET_HEAD;
    protected static final String XDOCLET_TAIL;
    protected static final int XDOCLET_HEAD_LEN;
    protected static final int XDOCLET_TAIL_LEN;
    private static TemplateEngine instance;
    protected transient PrettyPrintWriter out;
    protected transient File output = null;
    protected transient String docEncoding = null;
    private transient URL templateURL = null;
    private transient int currentLineNum = 0;
    private Map tagMappings = new HashMap();
    private XJavaDoc _xJavaDoc;

    protected TemplateEngine() {
        this.registerTagHandlers();
    }

    public static TemplateEngine getEngineInstance() {
        return instance;
    }

    public static int skipWhitespace(String template, int i) {
        while (i < template.length() && Character.isWhitespace(template.charAt(i))) {
            ++i;
        }
        return i;
    }

    protected static int getLineNumber(String template, int tillIndex) {
        int NL_LEN = "\n".length();
        int index = 0;
        int lineNumber = 0;
        while ((index = template.indexOf("\n", index)) != -1) {
            ++lineNumber;
            if ((index += NL_LEN) < tillIndex) continue;
        }
        return lineNumber;
    }

    public URL getTemplateURL() {
        return this.templateURL;
    }

    public File getOutput() {
        return this.output;
    }

    public int getCurrentLineNum() {
        return this.currentLineNum;
    }

    public TemplateTagHandler getTagHandlerFor(String prefix) throws TemplateException {
        Log log = LogUtil.getLog(TemplateEngine.class, "getTagHandlerFor");
        TemplateTagHandler tagHandler = (TemplateTagHandler)this.tagMappings.get(prefix);
        if (log.isDebugEnabled()) {
            log.debug((Object)("prefix=" + prefix));
            log.debug((Object)("tagHandler=" + tagHandler));
        }
        if (tagHandler == null) {
            String msg = Translator.getString(XDocletTemplateMessages.class, "TEMPLATE_NO_TAGHANDLER", new String[]{"'XDt" + prefix + "'"});
            log.error((Object)msg);
            throw new TemplateException(msg);
        }
        return tagHandler;
    }

    public Set getNamespaces() {
        return this.tagMappings.keySet();
    }

    public void setXJavaDoc(XJavaDoc xJavaDoc) {
        this._xJavaDoc = xJavaDoc;
        TemplateTagHandler.setXJavaDoc(this._xJavaDoc);
    }

    public void setWriter(PrettyPrintWriter out) {
        this.out = out;
    }

    public void setCurrentLineNum(int currentLineNum) {
        this.currentLineNum = currentLineNum;
    }

    public void setTemplateURL(URL templateURL) {
        this.templateURL = templateURL;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setTagHandlerFor(String prefix, TemplateTagHandler tagHandler) throws TemplateException {
        Log log = LogUtil.getLog(TemplateEngine.class, "setTagHandlerFor");
        if (log.isDebugEnabled()) {
            log.debug((Object)("prefix=" + prefix));
            log.debug((Object)("tagHandler=" + tagHandler));
        }
        this.tagMappings.put(prefix, tagHandler);
    }

    public void setDocEncoding(String string) {
        this.docEncoding = string;
    }

    public final void print(String output) {
        if (this.out != null) {
            this.out.print(output);
            this.out.flush();
        }
    }

    public void generate(String template) throws TemplateException {
        int index = 0;
        int prevIndex = 0;
        while (true) {
            if ((index = template.indexOf(XDOCLET_HEAD, prevIndex)) == -1) break;
            this.print(template.substring(prevIndex, index));
            prevIndex = this.handleTag(index, template);
        }
        this.print(template.substring(prevIndex));
    }

    public String outputOf(String template) throws TemplateException {
        PrettyPrintWriter oldOut = this.out;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.out = new PrettyPrintWriter(bout);
        this.generate(template);
        this.out.close();
        this.out = oldOut;
        return new String(bout.toByteArray());
    }

    public void start() throws TemplateException {
        Log log = LogUtil.getLog(TemplateEngine.class, "start");
        this.output.getParentFile().mkdirs();
        String content = FileManager.getURLContent(this.getTemplateURL());
        if (content != null) {
            PrettyPrintWriter out = null;
            try {
                String encoding = this.docEncoding;
                if (encoding == null) {
                    encoding = this._xJavaDoc.getDocEncoding();
                }
                out = encoding == null ? new PrettyPrintWriter(new BufferedWriter(new FileWriter(this.output))) : new PrettyPrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.output), encoding)));
                this.setWriter(out);
                this.setCurrentLineNum(0);
                this.generate(content);
                this.setWriter(null);
            }
            catch (IOException ex) {
                String msg = Translator.getString(XDocletTemplateMessages.class, "TEMPLATE_ERROR_WRITING_OUTPUT", new String[]{this.output.toString()});
                log.error((Object)msg, (Throwable)ex);
                throw new TemplateException(ex, msg);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        } else {
            String msg = Translator.getString(XDocletTemplateMessages.class, "TEMPLATE_NOT_FOUND", new String[]{this.getTemplateURL().toString()});
            log.error((Object)msg);
            throw new TemplateException(msg);
        }
    }

    protected int handleTag(int index, String template) throws TemplateException {
        int i = index + XDOCLET_HEAD_LEN;
        StringBuffer cmd = new StringBuffer();
        TagContext tagContext = new TagContext();
        Properties attributes = new Properties();
        i = this.extractTagName(template, i, cmd);
        i = this.doInitialTagParse(template, i, tagContext);
        i = this.extractAttributes(tagContext, template, i, attributes);
        if (tagContext.isBlock()) {
            i = this.handleBlockTag(i, template, cmd.toString(), attributes);
        } else {
            this.invokeContentMethod(cmd.toString(), attributes, template, i);
        }
        return i;
    }

    protected Object invokeMethod(String cmd, Object[] params1, Object[] params2, String template, int i) throws TemplateException {
        TemplateTagHandler cmdImplProvider;
        Log log = LogUtil.getLog(TemplateEngine.class, "invokeMethod");
        int colon = cmd.indexOf(58);
        if (colon < 0) {
            log.error((Object)("Invoking method failed: XD" + cmd + " is not valid because it does not contain ':' , line=" + TemplateEngine.getLineNumber(template, i) + " of template file: " + this.getTemplateURL()));
            throw new TemplateException(Translator.getString(XDocletTemplateMessages.class, "TEMPLATE_INVOKE_METHOD_FAILED", new String[]{"XD" + cmd, Integer.toString(TemplateEngine.getLineNumber(template, i)), this.getTemplateURL().toString()}));
        }
        String prefix = cmd.substring(0, colon);
        String methodName = cmd.substring(colon + 1);
        try {
            cmdImplProvider = this.getTagHandlerFor(prefix.substring(1));
        }
        catch (TemplateException e) {
            log.error((Object)("Error occured at/around line " + TemplateEngine.getLineNumber(template, i) + ", offending template tag: XD" + cmd));
            throw e;
        }
        String className = cmdImplProvider.getClass().getName();
        try {
            Class[] paramTypes = new Class[params1.length];
            for (int j = 0; j < params1.length; ++j) {
                paramTypes[j] = params1[j].getClass();
            }
            Method m = cmdImplProvider.getClass().getMethod(methodName, paramTypes);
            return this.invoke(m, cmdImplProvider, params1);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof TemplateException) {
                throw (TemplateException)e.getTargetException();
            }
            log.error((Object)("Invoking method failed: " + className + '.' + methodName + ", line=" + TemplateEngine.getLineNumber(template, i) + " of template file: " + this.getTemplateURL()), (Throwable)e);
            throw new TemplateException(Translator.getString(XDocletTemplateMessages.class, "TEMPLATE_INVOKE_METHOD_FAILED", new String[]{className, methodName, Integer.toString(TemplateEngine.getLineNumber(template, i)), this.getTemplateURL().toString(), e.getMessage()}));
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Invoking method failed: " + className + '.' + methodName + ", line=" + TemplateEngine.getLineNumber(template, i) + " of template file: " + this.getTemplateURL()), (Throwable)e);
            throw new TemplateException(Translator.getString(XDocletTemplateMessages.class, "TEMPLATE_INVOKE_METHOD_FAILED", new String[]{className, methodName, Integer.toString(TemplateEngine.getLineNumber(template, i)), this.getTemplateURL().toString(), e.getMessage()}));
        }
        catch (NoSuchMethodException e) {
            Class[] paramTypes = new Class[params2.length];
            try {
                for (int j = 0; j < params2.length; ++j) {
                    paramTypes[j] = params2[j].getClass();
                }
                Method m = cmdImplProvider.getClass().getMethod(methodName, paramTypes);
                return this.invoke(m, cmdImplProvider, params2);
            }
            catch (NoSuchMethodException nsme) {
                log.error((Object)("Could not find method " + className + '.' + methodName + " in class " + cmdImplProvider.getClass().getName()));
                throw new TemplateException(Translator.getString(XDocletTemplateMessages.class, "TEMPLATE_NO_SUCH_METHOD", new String[]{methodName, cmdImplProvider.getClass().getName(), nsme.getMessage()}));
            }
            catch (InvocationTargetException e2) {
                if (e2.getTargetException() instanceof TemplateException) {
                    throw (TemplateException)e2.getTargetException();
                }
                log.error((Object)("Invoking method failed: " + className + '.' + methodName + ", line=" + TemplateEngine.getLineNumber(template, i) + " of template file: " + this.getTemplateURL()), (Throwable)e2);
                throw new TemplateException(Translator.getString(XDocletTemplateMessages.class, "TEMPLATE_INVOKE_METHOD_FAILED", new String[]{className, methodName, Integer.toString(TemplateEngine.getLineNumber(template, i)), this.getTemplateURL().toString(), e2.getMessage()}));
            }
            catch (IllegalAccessException e2) {
                log.error((Object)("Invoking method failed: " + className + '.' + methodName + ", line=" + TemplateEngine.getLineNumber(template, i) + " of template file: " + this.getTemplateURL()), (Throwable)e2);
                throw new TemplateException(Translator.getString(XDocletTemplateMessages.class, "TEMPLATE_INVOKE_METHOD_FAILED", new String[]{className, methodName, Integer.toString(TemplateEngine.getLineNumber(template, i)), this.getTemplateURL().toString(), e2.getMessage()}));
            }
        }
    }

    protected void invokeContentMethod(String cmd, Properties attributes, String template, int i) throws TemplateException {
        Object[] params1 = null;
        Object[] params2 = null;
        if (attributes.size() > 0) {
            params1 = new Object[]{attributes};
            params2 = new Object[]{};
        } else {
            params1 = new Object[]{};
            params2 = new Object[]{attributes};
        }
        String result = (String)this.invokeMethod(cmd, params1, params2, template, i);
        if (result != null && this.out != null) {
            this.print(result);
        }
    }

    protected Object invoke(Method m, Object cmdImplProvider, Object[] params1) throws InvocationTargetException, IllegalAccessException, TemplateException {
        return m.invoke(cmdImplProvider, params1);
    }

    private void registerTagHandlers() {
        Log log = LogUtil.getLog(TemplateEngine.class, "registerTagHandlers");
        List modules = ModuleFinder.findModules();
        for (XDocletModule module : modules) {
            log.debug((Object)("Registering module " + module));
            List tagHandlerDefinitions = module.getTagHandlerDefinitions();
            for (TagHandlerDefinition thd : tagHandlerDefinitions) {
                log.debug((Object)("Registering tag handler " + thd.namespace));
                try {
                    TemplateTagHandler handler = (TemplateTagHandler)Class.forName(thd.className).newInstance();
                    log.debug((Object)("Add tagHandler " + thd.namespace + " (" + thd.className + ')'));
                    this.setTagHandlerFor(thd.namespace, handler);
                }
                catch (Exception e) {
                    log.error((Object)("Couldn't instantiate " + thd.className + " taghandler "), (Throwable)e);
                }
            }
        }
    }

    private int extractAttributes(TagContext tagContext, String template, int i, Properties attributes) throws TemplateException {
        while (tagContext.hasMoreAttributes()) {
            i = this.extractNextAttribute(template, i, tagContext, attributes);
        }
        return i;
    }

    private int extractTagName(String template, int index, StringBuffer cmd) {
        while (!Character.isWhitespace(template.charAt(index)) && template.charAt(index) != '>' && template.charAt(index) != '/') {
            cmd.append(template.charAt(index));
            ++index;
        }
        return index;
    }

    private int extractNextAttribute(String template, int index, TagContext tagContext, Properties attributes) throws TemplateException {
        StringBuffer attributeValue;
        StringBuffer attributeName;
        block13: {
            attributeName = new StringBuffer();
            attributeValue = new StringBuffer();
            char quoteChar = '\"';
            try {
                while (template.charAt(index) != '=' && !Character.isWhitespace(template.charAt(index))) {
                    attributeName.append(template.charAt(index));
                    ++index;
                }
                if (template.charAt(index = TemplateEngine.skipWhitespace(template, index)) == '=') {
                    ++index;
                } else {
                    throw new TemplateException(Translator.getString(XDocletTemplateMessages.class, "TEMPLATE_EQUALS_EXPECTED", new String[]{Integer.toString(TemplateEngine.getLineNumber(template, index)), this.getTemplateURL().toString()}));
                }
                index = TemplateEngine.skipWhitespace(template, index);
                if (template.charAt(index) == '\"') {
                    ++index;
                    quoteChar = '\"';
                } else if (template.charAt(index) == '\'') {
                    ++index;
                    quoteChar = '\'';
                } else {
                    throw new TemplateException(Translator.getString(XDocletTemplateMessages.class, "TEMPLATE_QUOTE_EXPECTED", new String[]{Integer.toString(TemplateEngine.getLineNumber(template, index)), this.getTemplateURL().toString()}));
                }
                while (template.charAt(index) != quoteChar) {
                    attributeValue.append(template.charAt(index));
                    ++index;
                }
                ++index;
                tagContext.setHasMoreAttributes(true);
                if (attributeValue.toString().indexOf(XDOCLET_HEAD) != -1) {
                    attributeValue = new StringBuffer(this.outputOf(attributeValue.toString()));
                }
                if (template.charAt(index = TemplateEngine.skipWhitespace(template, index)) == '>') {
                    ++index;
                    tagContext.setBlock(true);
                    tagContext.setHasMoreAttributes(false);
                    break block13;
                }
                if (template.charAt(index) != '/') break block13;
                if (template.charAt(++index) == '>') {
                    ++index;
                    tagContext.setBlock(false);
                    tagContext.setHasMoreAttributes(false);
                    break block13;
                }
                throw new TemplateException(Translator.getString(XDocletTemplateMessages.class, "TEMPLATE_GT_EXPECTED", new String[]{Integer.toString(TemplateEngine.getLineNumber(template, index)), this.getTemplateURL().toString()}));
            }
            catch (StringIndexOutOfBoundsException ex) {
                throw new TemplateException(Translator.getString(XDocletTemplateMessages.class, "TEMPLATE_SYNTAX_ERROR", new String[]{Integer.toString(TemplateEngine.getLineNumber(template, index)), this.getTemplateURL().toString(), template}));
            }
        }
        attributes.setProperty(attributeName.toString(), attributeValue.toString());
        return index;
    }

    private int doInitialTagParse(String template, int index, TagContext tagContext) throws TemplateException {
        while (true) {
            if (template.charAt(index) == '>') {
                tagContext.setHasMoreAttributes(false);
                tagContext.setBlock(true);
                return ++index;
            }
            if (template.charAt(index) == '/') {
                if (template.charAt(++index) == '>') {
                    tagContext.setHasMoreAttributes(false);
                    tagContext.setBlock(false);
                    return ++index;
                }
                throw new TemplateException(Translator.getString(XDocletTemplateMessages.class, "TEMPLATE_GT_EXPECTED", new String[]{Integer.toString(TemplateEngine.getLineNumber(template, index)), this.getTemplateURL().toString()}));
            }
            if (!Character.isWhitespace(template.charAt(index))) break;
            index = TemplateEngine.skipWhitespace(template, index);
        }
        tagContext.setHasMoreAttributes(true);
        return index;
    }

    private int handleBlockTag(int index, String template, String cmd, Properties attributes) throws TemplateException {
        int openNestedElemCount = 1;
        String newBody = null;
        int bodyStartIndex = index;
        int bodyEndIndex = -1;
        while (index < template.length()) {
            int fromIndex = index;
            bodyEndIndex = template.indexOf(new StringBuffer(XDOCLET_TAIL).append(cmd).toString(), index);
            if (bodyEndIndex == -1) {
                throw new TemplateException(Translator.getString(XDocletTemplateMessages.class, "TEMPLATE_CLOSE_TAG_MISSING", new String[]{new StringBuffer(XDOCLET_TAIL).append(cmd).append('>').toString(), Integer.toString(TemplateEngine.getLineNumber(template, index)), this.getTemplateURL().toString()}));
            }
            --openNestedElemCount;
            index = bodyEndIndex + XDOCLET_TAIL_LEN + cmd.length();
            index = TemplateEngine.skipWhitespace(template, index);
            ++index;
            StringBuffer xdocletPrefixPlusCmd = new StringBuffer(XDOCLET_PREFIX).append(cmd);
            int nestedStartIndex = template.indexOf(xdocletPrefixPlusCmd.toString(), fromIndex);
            while (nestedStartIndex != -1 && nestedStartIndex < bodyEndIndex) {
                if (template.charAt(nestedStartIndex - 1) == '<') {
                    ++openNestedElemCount;
                } else {
                    throw new TemplateException(Translator.getString(XDocletTemplateMessages.class, "TEMPLATE_CORRESPONDING_TAG_MISSING", new String[]{new StringBuffer(XDOCLET_TAIL).append(cmd).append('>').toString(), Integer.toString(TemplateEngine.getLineNumber(template, index)), this.getTemplateURL().toString()}));
                }
                nestedStartIndex = template.indexOf(xdocletPrefixPlusCmd.toString(), nestedStartIndex + 1);
            }
            if (openNestedElemCount != 0) continue;
            break;
        }
        newBody = template.substring(bodyStartIndex, bodyEndIndex);
        int previousLineNum = this.currentLineNum;
        int localBodyLineNum = TemplateEngine.getLineNumber(template, bodyStartIndex);
        this.currentLineNum += localBodyLineNum;
        if (previousLineNum > 0) {
            --this.currentLineNum;
        }
        this.invokeBlockMethod(cmd, newBody, attributes, template, index);
        this.currentLineNum = previousLineNum;
        return index;
    }

    private void invokeBlockMethod(String cmd, String block, Properties attributes, String template, int i) throws TemplateException {
        Object[] params1 = null;
        Object[] params2 = null;
        if (attributes.size() > 0) {
            params1 = new Object[]{block, attributes};
            params2 = new Object[]{block};
        } else {
            params1 = new Object[]{block};
            params2 = new Object[]{block, attributes};
        }
        this.invokeMethod(cmd, params1, params2, template, i);
    }

    static {
        instance = new TemplateEngine();
        XDOCLET_PREFIX = "XD";
        XDOCLET_HEAD = "<" + XDOCLET_PREFIX;
        XDOCLET_TAIL = "</" + XDOCLET_PREFIX;
        XDOCLET_HEAD_LEN = XDOCLET_HEAD.length();
        XDOCLET_TAIL_LEN = XDOCLET_TAIL.length();
    }

    private static class TagContext {
        private boolean hasMoreAttributes = false;
        private boolean isBlock = false;

        private TagContext() {
        }

        public boolean isBlock() {
            return this.isBlock;
        }

        public void setHasMoreAttributes(boolean attributes) {
            this.hasMoreAttributes = attributes;
        }

        public void setBlock(boolean block) {
            this.isBlock = block;
        }

        public boolean hasMoreAttributes() {
            return this.hasMoreAttributes;
        }
    }
}

