/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.GetPublisherAssertions;
import org.apache.juddi.datatype.response.PublisherAssertions;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class GetPublisherAssertionsFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$function$GetPublisherAssertionsFunction == null ? (class$org$apache$juddi$function$GetPublisherAssertionsFunction = GetPublisherAssertionsFunction.class$("org.apache.juddi.function.GetPublisherAssertionsFunction")) : class$org$apache$juddi$function$GetPublisherAssertionsFunction));
    static /* synthetic */ Class class$org$apache$juddi$function$GetPublisherAssertionsFunction;

    public GetPublisherAssertionsFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        GetPublisherAssertions request = (GetPublisherAssertions)regObject;
        String generic = request.getGeneric();
        AuthInfo authInfo = request.getAuthInfo();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            dataStore.beginTrans();
            Publisher publisher = this.getPublisher(authInfo, dataStore);
            String publisherID = publisher.getPublisherID();
            Vector assertionVector = dataStore.getAssertions(publisherID);
            dataStore.commit();
            PublisherAssertions assertions = new PublisherAssertions();
            assertions.setGeneric(generic);
            assertions.setOperator(Config.getOperator());
            assertions.setPublisherAssertionVector(assertionVector);
            PublisherAssertions publisherAssertions = assertions;
            return publisherAssertions;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

