/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.PublisherInfo;
import org.apache.juddi.datatype.response.PublisherInfos;
import org.apache.juddi.datatype.response.PublisherList;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class PublisherListHandler
extends AbstractHandler {
    public static final String TAG_NAME = "publisherList";
    private HandlerMaker maker = null;

    protected PublisherListHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        PublisherList obj = new PublisherList();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setGeneric(element.getAttribute("generic"));
        obj.setOperator(element.getAttribute("operator"));
        String truncValue = element.getAttribute("truncated");
        if (truncValue != null) {
            obj.setTruncated(truncValue.equalsIgnoreCase("true"));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "publisherInfos")).size() > 0) {
            handler = this.maker.lookup("publisherInfos");
            obj.setPublisherInfos((PublisherInfos)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        PublisherInfos infos;
        PublisherList list = (PublisherList)object;
        String generic = list.getGeneric();
        generic = this.getGeneric(generic);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        AbstractHandler handler = null;
        element.setAttribute("generic", generic);
        String operator = list.getOperator();
        if (operator != null) {
            element.setAttribute("operator", operator);
        } else {
            element.setAttribute("operator", "");
        }
        boolean truncated = list.isTruncated();
        if (truncated) {
            element.setAttribute("truncated", "true");
        }
        if ((infos = list.getPublisherInfos()) != null) {
            handler = this.maker.lookup("publisherInfos");
            handler.marshal(infos, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        PublisherList list = new PublisherList();
        list.setGeneric("1.0");
        list.setOperator("jUDDI.org");
        list.setTruncated(false);
        list.addPublisherInfo(new PublisherInfo("sviens", "Steve Viens"));
        list.addPublisherInfo(new PublisherInfo("jdoe", "John Doe"));
        System.out.println();
        RegistryObject regObject = list;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

