/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchException;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.latch.LatchStats;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.latch.SharedLatch;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SharedLatchImpl
implements SharedLatch {
    private String name = null;
    private List waiters = new ArrayList();
    private LatchStats stats = new LatchStats();
    private EnvironmentImpl env = null;
    private boolean noteLatch;
    private boolean exclusiveOnly;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SharedLatchImpl(String name, EnvironmentImpl env) {
        this.name = name;
        this.env = env;
        this.exclusiveOnly = false;
    }

    public void setExclusiveOnly(boolean exclusiveOnly) {
        this.exclusiveOnly = exclusiveOnly;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public synchronized boolean setNoteLatch(boolean noteLatch) {
        this.noteLatch = noteLatch;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void acquireExclusive() throws DatabaseException {
        block11: {
            try {
                try {
                    Thread thread = Thread.currentThread();
                    int index = this.indexOf(thread);
                    if (index >= 0) {
                        throw new LatchException(this.getNameString() + " reentrancy/upgrade not allowed");
                    }
                    Owner owner = new Owner(thread, 1);
                    this.waiters.add(owner);
                    if (this.waiters.size() == 1) {
                        ++this.stats.nAcquiresNoWaiters;
                    } else {
                        ++this.stats.nAcquiresWithContention;
                        while (this.waiters.get(0) != owner) {
                            this.wait();
                        }
                    }
                    ++owner.nAcquires;
                    if (!$assertionsDisabled && this.noteLatch && !this.noteLatch()) {
                        throw new AssertionError();
                    }
                    Object var5_5 = null;
                    if ($assertionsDisabled) break block11;
                }
                catch (InterruptedException e) {
                    throw new RunRecoveryException(this.env, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                    throw new AssertionError();
                }
                throw throwable;
            }
            if (!EnvironmentImpl.maybeForceYield()) {
                throw new AssertionError();
            }
        }
    }

    public boolean acquireExclusiveNoWait() throws DatabaseException {
        block8: {
            block9: {
                boolean bl;
                try {
                    Thread thread = Thread.currentThread();
                    int index = this.indexOf(thread);
                    if (index >= 0) break block8;
                    if (this.waiters.size() != 0) break block9;
                    Owner owner = new Owner(thread, 1);
                    this.waiters.add(owner);
                    ++owner.nAcquires;
                    ++this.stats.nAcquiresNoWaiters;
                    if (!$assertionsDisabled && this.noteLatch && !this.noteLatch()) {
                        throw new AssertionError();
                    }
                    bl = true;
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                        throw new AssertionError();
                    }
                    throw throwable;
                }
                if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                    throw new AssertionError();
                }
                return bl;
            }
            boolean bl = false;
            Object var6_7 = null;
            if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                throw new AssertionError();
            }
            return bl;
        }
        throw new LatchException(this.getNameString() + " reentrancy/upgrade not allowed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void acquireShared() throws DatabaseException {
        block11: {
            if (this.exclusiveOnly) {
                this.acquireExclusive();
                return;
            }
            try {
                try {
                    Owner owner;
                    Thread thread = Thread.currentThread();
                    int index = this.indexOf(thread);
                    if (index < 0) {
                        owner = new Owner(thread, 0);
                        this.waiters.add(owner);
                    } else {
                        owner = (Owner)this.waiters.get(index);
                    }
                    while (this.indexOf(thread) > this.firstWriter()) {
                        this.wait();
                    }
                    ++owner.nAcquires;
                    ++this.stats.nAcquireSharedSuccessful;
                    if (!$assertionsDisabled && this.noteLatch && !this.noteLatch()) {
                        throw new AssertionError();
                    }
                    Object var5_5 = null;
                    if ($assertionsDisabled) break block11;
                }
                catch (InterruptedException e) {
                    throw new RunRecoveryException(this.env, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                    throw new AssertionError();
                }
                throw throwable;
            }
            if (!EnvironmentImpl.maybeForceYield()) {
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isOwner() {
        block6: {
            boolean bl;
            try {
                Thread thread = Thread.currentThread();
                int index = this.indexOf(thread);
                if (index >= 0 && index <= this.firstWriter()) break block6;
                bl = false;
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                    throw new AssertionError();
                }
                throw throwable;
            }
            if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                throw new AssertionError();
            }
            return bl;
        }
        boolean bl = true;
        Object var5_6 = null;
        if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
            throw new AssertionError();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void release() throws LatchNotHeldException {
        try {
            int index;
            block12: {
                block11: {
                    Thread thread = Thread.currentThread();
                    index = this.indexOf(thread);
                    if (index < 0) break block11;
                    if (index <= this.firstWriter()) break block12;
                }
                Object var5_3 = null;
                if ($assertionsDisabled || EnvironmentImpl.maybeForceYield()) return;
                throw new AssertionError();
            }
            Owner owner = (Owner)this.waiters.get(index);
            --owner.nAcquires;
            if (owner.nAcquires == 0) {
                this.waiters.remove(index);
                if (!$assertionsDisabled && this.noteLatch && !this.unNoteLatch()) {
                    throw new AssertionError();
                }
                this.notifyAll();
            }
            ++this.stats.nReleases;
            Object var5_4 = null;
            if ($assertionsDisabled) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if ($assertionsDisabled || EnvironmentImpl.maybeForceYield()) throw throwable;
            throw new AssertionError();
        }
        if (EnvironmentImpl.maybeForceYield()) return;
        throw new AssertionError();
    }

    public void releaseIfOwner() throws LatchNotHeldException {
        this.release();
    }

    private int indexOf(Thread thread) {
        Iterator i = this.waiters.iterator();
        int index = 0;
        while (i.hasNext()) {
            Owner owner = (Owner)i.next();
            if (owner.thread == thread) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private int firstWriter() {
        Iterator i = this.waiters.iterator();
        int index = 0;
        while (i.hasNext()) {
            Owner owner = (Owner)i.next();
            if (owner.type == 1) {
                return index;
            }
            ++index;
        }
        return Integer.MAX_VALUE;
    }

    private String getNameString() {
        return LatchSupport.latchTable.getNameString(this.name);
    }

    private boolean noteLatch() throws LatchException {
        return LatchSupport.latchTable.noteLatch(this);
    }

    private boolean unNoteLatch() throws LatchNotHeldException {
        return LatchSupport.latchTable.unNoteLatch(this, this.name);
    }

    public synchronized boolean isWriteLockedByCurrentThread() {
        if (this.waiters.size() > 0) {
            Owner curOwner = (Owner)this.waiters.get(0);
            return curOwner.thread == Thread.currentThread() && curOwner.type == 1;
        }
        return false;
    }

    static {
        $assertionsDisabled = !SharedLatchImpl.class.desiredAssertionStatus();
    }

    private static class Owner {
        static final int SHARED = 0;
        static final int EXCLUSIVE = 1;
        Thread thread;
        int type;
        int nAcquires;

        Owner(Thread thread, int type) {
            this.thread = thread;
            this.type = type;
        }
    }
}

