/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumFormat
extends Format {
    private static final long serialVersionUID = 1069833955604373538L;
    private String[] names;
    private transient Object[] values;

    EnumFormat(Class type) {
        super(type);
        this.values = type.getEnumConstants();
        this.names = new String[this.values.length];
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i] = ((Enum)this.values[i]).name();
        }
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public List<String> getEnumConstants() {
        return Arrays.asList(this.names);
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> newFormats) {
    }

    @Override
    void initialize(Catalog catalog) {
        if (this.values == null) {
            Class cls = this.getType();
            this.values = new Object[this.names.length];
            for (int i = 0; i < this.names.length; ++i) {
                this.values[i] = Enum.valueOf(cls, this.names[i]);
            }
        }
    }

    @Override
    Object newArray(int len) {
        return Array.newInstance(this.getType(), len);
    }

    @Override
    Object newInstance(EntityInput input, boolean rawAccess) {
        int index = input.readPackedInt();
        if (rawAccess) {
            return new RawObject((RawType)this, this.names[index]);
        }
        return Enum.valueOf(this.getType(), this.names[index]);
    }

    @Override
    void writeObject(Object o, EntityOutput output, boolean rawAccess) {
        if (rawAccess) {
            String name = ((RawObject)o).getEnum();
            for (int i = 0; i < this.names.length; ++i) {
                if (!this.names[i].equals(name)) continue;
                output.writePackedInt(i);
                return;
            }
        } else {
            for (int i = 0; i < this.values.length; ++i) {
                if (o != this.values[i]) continue;
                output.writePackedInt(i);
                return;
            }
        }
        throw new IllegalStateException("Bad enum: " + o);
    }

    @Override
    void readObject(Object o, EntityInput input, boolean rawAccess) {
    }

    @Override
    void skipContents(EntityInput input) {
        input.skipFast(input.getPackedIntByteLength());
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof EnumFormat) {
            EnumFormat o = (EnumFormat)other;
            return super.equals(o) && Arrays.equals(this.names, o.names);
        }
        return false;
    }
}

