/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.jboss.aop.asintegration.core.AspectManagerServiceDelegate;
import org.jboss.aop.asintegration.core.AspectManagerServiceDelegateJRockit;
import org.jboss.aop.deployment.AbstractAspectManagerService;
import org.jboss.mx.notification.ListenerRegistration;
import org.jboss.mx.notification.ListenerRegistry;

public class AspectManagerService
extends AbstractAspectManagerService {
    private AtomicLong sequenceNumber = new AtomicLong();
    private ListenerRegistry registry = new ListenerRegistry();

    protected AspectManagerServiceDelegate createDelegate() {
        return new AspectManagerServiceDelegateJRockit();
    }

    public void attachClass(String classname) {
        Notification msg = new Notification("AOP class attached", (Object)this, this.sequenceNumber.incrementAndGet());
        msg.setUserData(classname);
        this.sendNotification(msg);
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        try {
            this.registry.add(listener, filter, handback);
        }
        catch (JMException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.registry.remove(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.registry.remove(listener, filter, handback);
    }

    public void sendNotification(Notification notification) {
        ListenerRegistry.ListenerRegistrationIterator iterator = this.registry.iterator();
        while (iterator.hasNext()) {
            ListenerRegistration registration = iterator.nextRegistration();
            NotificationFilter filter = registration.getFilter();
            if (filter == null) {
                this.handleNotification(registration.getListener(), notification, registration.getHandback());
                continue;
            }
            if (!filter.isNotificationEnabled(notification)) continue;
            this.handleNotification(registration.getListener(), notification, registration.getHandback());
        }
    }

    public void handleNotification(NotificationListener listener, Notification notification, Object handback) {
        try {
            listener.handleNotification(notification, handback);
        }
        catch (Throwable ignored) {
            this.log.debug((Object)"Ignored unhandled throwable from listener", ignored);
        }
    }
}

