/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.bisocket;

import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jboss.logging.XLevel;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.samples.bisocket.BisocketSampleServer;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.bisocket.BisocketServerInvoker;
import org.jboss.remoting.transport.socket.SocketServerInvoker;

public class BisocketSampleClient {
    private static Logger log = Logger.getLogger(BisocketSampleClient.class);

    public void makeInvocation(String locatorURI) throws Throwable {
        InvokerLocator clientLocator = new InvokerLocator(locatorURI);
        Client client = new Client(clientLocator);
        client.connect();
        log.info((Object)"client is connected");
        if ("abc".equals(client.invoke("abc"))) {
            log.info((Object)"connection is good");
        } else {
            log.info((Object)"Should have gotten \"abc\" in reply");
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("isCallbackServer", "true");
        TestCallbackHandler callbackHandler = new TestCallbackHandler();
        client.addListener((InvokerCallbackHandler)callbackHandler, metadata);
        Set callbackConnectors = client.getCallbackConnectors(callbackHandler);
        if (callbackConnectors.size() != 1) {
            log.info((Object)"There should be one callback Connector");
        } else {
            Connector callbackConnector = (Connector)callbackConnectors.iterator().next();
            BisocketServerInvoker serverInvoker = (BisocketServerInvoker)callbackConnector.getServerInvoker();
            Field field = SocketServerInvoker.class.getDeclaredField("serverSockets");
            field.setAccessible(true);
            List serverSockets = (List)field.get(serverInvoker);
            log.info((Object)("number of ServerSockets held by callback BisocketServerInvoker: " + serverSockets.size()));
        }
        client.invoke("CALLBACK");
        if (callbackHandler.getCounter() == 1) {
            log.info((Object)"received callback");
        } else {
            log.info((Object)"didn't receive callback");
        }
        client.removeListener(callbackHandler);
        client.disconnect();
    }

    public static void main(String[] args) {
        Logger.getLogger((String)"org.jboss.remoting").setLevel(XLevel.INFO);
        Logger.getLogger((String)"org.jboss.test.remoting").setLevel(Level.INFO);
        String pattern = "[%d{ABSOLUTE}] [%t] %5p (%F:%L) - %m%n";
        PatternLayout layout = new PatternLayout(pattern);
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)layout);
        Logger.getRootLogger().addAppender((Appender)consoleAppender);
        try {
            String host = InetAddress.getLocalHost().getHostName();
            int port = BisocketSampleServer.port;
            String locatorURI = "bisocket://" + host + ":" + port;
            BisocketSampleClient client = new BisocketSampleClient();
            client.makeInvocation(locatorURI);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static class TestCallbackHandler
    implements InvokerCallbackHandler {
        private int counter;

        TestCallbackHandler() {
        }

        public void handleCallback(Callback callback) throws HandleCallbackException {
            ++this.counter;
        }

        public int getCounter() {
            return this.counter;
        }
    }
}

