/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.bisocket;

import java.net.InetAddress;
import java.util.HashSet;
import javax.management.MBeanServer;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jboss.logging.XLevel;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transport.Connector;

public class BisocketSampleServer {
    public static int port = 4567;
    private static Logger log = Logger.getLogger(BisocketSampleServer.class);
    protected Connector connector;

    protected void setupServer(String locatorURI) throws Exception {
        InvokerLocator serverLocator = new InvokerLocator(locatorURI);
        this.connector = new Connector(serverLocator);
        this.connector.create();
        SampleInvocationHandler invocationHandler = new SampleInvocationHandler();
        this.connector.addInvocationHandler("test", invocationHandler);
        this.connector.start();
        log.info((Object)("Started remoting server with locator uri of: " + locatorURI));
    }

    protected void shutdownServer() throws Exception {
        if (this.connector != null) {
            this.connector.stop();
            log.info((Object)"shut down server");
        }
    }

    public static void main(String[] args) {
        try {
            Logger.getLogger((String)"org.jboss.remoting").setLevel(XLevel.INFO);
            Logger.getLogger((String)"org.jboss.test.remoting").setLevel(Level.INFO);
            String pattern = "[%d{ABSOLUTE}] [%t] %5p (%F:%L) - %m%n";
            PatternLayout layout = new PatternLayout(pattern);
            ConsoleAppender consoleAppender = new ConsoleAppender((Layout)layout);
            Logger.getRootLogger().addAppender((Appender)consoleAppender);
            String host = InetAddress.getLocalHost().getHostAddress();
            String locatorURI = "bisocket://" + host + ":" + port;
            BisocketSampleServer server = new BisocketSampleServer();
            server.setupServer(locatorURI);
            System.in.read();
            server.shutdownServer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class SampleInvocationHandler
    implements ServerInvocationHandler {
        private HashSet callbackHandlers = new HashSet();

        SampleInvocationHandler() {
        }

        public void addListener(InvokerCallbackHandler callbackHandler) {
            this.callbackHandlers.add(callbackHandler);
        }

        public Object invoke(InvocationRequest invocation) throws Throwable {
            Object param = invocation.getParameter();
            if ("CALLBACK".equals(param)) {
                for (InvokerCallbackHandler handler : this.callbackHandlers) {
                    handler.handleCallback(new Callback("callback"));
                }
            }
            return param;
        }

        public void removeListener(InvokerCallbackHandler callbackHandler) {
            this.callbackHandlers.remove(callbackHandler);
        }

        public void setMBeanServer(MBeanServer server) {
        }

        public void setInvoker(ServerInvoker invoker) {
        }
    }
}

