/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.socket.ClientSocketWrapper;

public class ServerSocketWrapper
extends ClientSocketWrapper {
    private static final Logger log = Logger.getLogger(ServerSocketWrapper.class);

    public ServerSocketWrapper(Socket socket) throws Exception {
        super(socket);
    }

    public ServerSocketWrapper(Socket socket, Map metadata, Integer timeout) throws Exception {
        super(socket, metadata, timeout);
    }

    public synchronized void close() throws IOException {
        if (this.socket != null) {
            try {
                this.getOutputStream().write(254);
                this.getOutputStream().write(254);
                this.getOutputStream().flush();
                log.trace((Object)(this + " wrote CLOSING"));
            }
            catch (IOException e) {
                log.trace((Object)(this + " unable to writing CLOSING byte"), (Throwable)e);
            }
            super.close();
            this.socket = null;
        }
    }

    public void checkConnection() throws IOException {
        int ACK = 0;
        try {
            ACK = this.getInputStream().read();
        }
        catch (EOFException eof) {
            log.trace((Object)"EOFException waiting on ACK in read().");
            throw eof;
        }
        catch (IOException e) {
            log.debug((Object)("IOException when reading in ACK: " + e.getMessage()));
            log.trace((Object)"IOException when reading in ACK", (Throwable)e);
            throw e;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("acknowledge read byte: " + ACK + ": " + Thread.currentThread()));
        }
        OutputStream out = this.getOutputStream();
        out.write(ACK);
        out.flush();
    }

    public String toString() {
        Socket socket = this.getSocket();
        return "ServerSocketWrapper[" + socket + "." + Integer.toHexString(System.identityHashCode(socket)) + "]";
    }
}

