/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.entity;

import java.util.Collection;
import xdoclet.DocletSupport;
import xdoclet.XDocletException;
import xdoclet.modules.ejb.EjbTagsHandler;
import xdoclet.modules.ejb.entity.BmpTagsHandler;
import xdoclet.modules.ejb.entity.CmpTagsHandler;
import xjavadoc.XClass;
import xjavadoc.XMethod;

public class EntityTagsHandler
extends EjbTagsHandler {
    public static boolean isEntity(XClass clazz) {
        return clazz.isA("javax.ejb.EntityBean");
    }

    public static boolean isEjbSelectMethod(XMethod method) {
        if (!method.getName().startsWith("ejbSelect")) {
            return false;
        }
        if (method.getName().length() <= "ejbSelect".length()) {
            return false;
        }
        if ((method.getModifierSpecifier() & 0x400) == 0 || (method.getModifierSpecifier() & 1) == 0) {
            return false;
        }
        return !method.getReturnType().getType().getName().equals("void");
    }

    public void ifEntity(String template) throws XDocletException {
        if (EntityTagsHandler.isEntity(EntityTagsHandler.getCurrentClass())) {
            this.generate(template);
        }
    }

    public String persistenceType() throws XDocletException {
        if (CmpTagsHandler.isEntityCmp(EntityTagsHandler.getCurrentClass()) && !BmpTagsHandler.isEntityBmp(EntityTagsHandler.getCurrentClass())) {
            return "Container";
        }
        return "Bean";
    }

    public void forAllEntityBeans(String template) throws XDocletException {
        Collection classes = EntityTagsHandler.getXJavaDoc().getSourceClasses();
        for (XClass clazz : classes) {
            EntityTagsHandler.setCurrentClass((XClass)clazz);
            if (DocletSupport.isDocletGenerated((XClass)EntityTagsHandler.getCurrentClass()) || !this.hasHavingClassTag(EntityTagsHandler.getCurrentClass()) || !EntityTagsHandler.isEntity(EntityTagsHandler.getCurrentClass())) continue;
            this.generate(template);
        }
    }

    public String reentrant() throws XDocletException {
        String value = EntityTagsHandler.getTagValue((int)0, (String)"ejb:bean", (String)"reentrant", null, (String)"false", (boolean)true, (boolean)false);
        String ejbSpec = EjbTagsHandler.getEjbSpec();
        if (ejbSpec.equals("1.1") || ejbSpec.equals("2.0")) {
            return value.substring(0, 1).toUpperCase() + value.substring(1).toLowerCase();
        }
        return value.toLowerCase();
    }

    public void forAllEjbSelectMethods(String template) throws XDocletException {
        XMethod old_cur_method = EntityTagsHandler.getCurrentMethod();
        for (XMethod method : EntityTagsHandler.getCurrentClass().getMethods(true)) {
            if (!EntityTagsHandler.isEjbSelectMethod(method)) continue;
            EntityTagsHandler.setCurrentMethod((XMethod)method);
            this.generate(template);
        }
        EntityTagsHandler.setCurrentMethod((XMethod)old_cur_method);
    }
}

