/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.Annotation;
import java.util.List;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.kernel.plugins.annotations.AnnotationPlugin;
import org.jboss.kernel.plugins.annotations.BaseMetaDataAnnotationPlugin;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.metadata.spi.MetaData;
import org.jboss.reflect.spi.AnnotatedInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationPlugin<T extends AnnotatedInfo, C extends Annotation>
extends BaseMetaDataAnnotationPlugin<T, C>
implements AnnotationPlugin<T, C> {
    protected AbstractAnnotationPlugin(Class<C> annotation) {
        super(annotation);
    }

    protected boolean isMetaDataAlreadyPresent(T info, C annotation, KernelControllerContext context) {
        return this.isMetaDataAlreadyPresent(info, annotation, context.getBeanMetaData());
    }

    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(T info, MetaData retrieval, C annotation, KernelControllerContext context) throws Throwable {
        return this.internalApplyAnnotation((AnnotatedInfo)info, retrieval, (Annotation)annotation, context.getBeanMetaData());
    }

    @Override
    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(T info, MetaData retrieval, C annotation, BeanMetaData beanMetaData) throws Throwable {
        return this.internalApplyAnnotation((AnnotatedInfo)info, (Annotation)annotation, beanMetaData);
    }

    @Override
    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(T info, C annotation, BeanMetaData beanMetaData) throws Throwable {
        this.log.warn((Object)("Probably missing annotation apply implementation: " + this));
        return null;
    }

    @Override
    public final void applyAnnotation(T info, MetaData retrieval, MetaDataVisitor visitor) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        if (!this.isCleanupOnly()) {
            List<MetaDataVisitorNode> nodes;
            Class annotationClass = this.getAnnotation();
            Annotation annotation = retrieval.getAnnotation(annotationClass);
            if (annotation == null) {
                if (trace) {
                    this.log.trace((Object)("No annotation: " + annotationClass.getName()));
                }
                return;
            }
            if (this.isMetaDataAlreadyPresent(info, annotation, visitor.getControllerContext())) {
                if (trace) {
                    this.log.trace((Object)("MetaDataAlreadyPresent, ignoring " + annotation));
                }
                return;
            }
            if (trace) {
                this.log.trace((Object)("Applying annotation: " + annotation));
            }
            if ((nodes = this.internalApplyAnnotation(info, retrieval, annotation, visitor.getControllerContext())) != null && !nodes.isEmpty()) {
                for (MetaDataVisitorNode node : nodes) {
                    node.initialVisit(visitor);
                    node.describeVisit(visitor);
                }
            }
        } else if (trace) {
            this.log.trace((Object)("Annotation " + this.getAnnotation() + " is @CleanupOnly, nothing to apply on install."));
        }
    }

    @Override
    public void cleanAnnotation(T info, MetaData retrieval, MetaDataVisitor visitor) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        if (this.isCleanup()) {
            Class annotationClass = this.getAnnotation();
            Annotation annotation = retrieval.getAnnotation(annotationClass);
            if (annotation == null) {
                if (trace) {
                    this.log.trace((Object)("No annotation: " + annotationClass.getName()));
                }
            } else {
                if (trace) {
                    this.log.trace((Object)("Cleaning annotation: " + annotation));
                }
                this.internalCleanAnnotation(info, retrieval, annotation, visitor.getControllerContext());
            }
        } else if (trace) {
            this.log.trace((Object)("Annotation " + this.getAnnotation() + " is not a @Cleanup annotation."));
        }
    }

    protected void internalCleanAnnotation(T info, MetaData retrieval, C annotation, KernelControllerContext context) throws Throwable {
    }

    protected AbstractBeanMetaData checkIfNotAbstractBeanMetaDataSpecific(BeanMetaData beanMetaData) {
        if (!(beanMetaData instanceof AbstractBeanMetaData)) {
            throw new IllegalArgumentException("Can only handle AbstractBeanMetaData: " + beanMetaData);
        }
        return (AbstractBeanMetaData)AbstractBeanMetaData.class.cast(beanMetaData);
    }
}

