/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
import EDU.oswego.cs.dl.util.concurrent.misc.Fraction;
import EDU.oswego.cs.dl.util.concurrent.misc.PrioritySemRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.RNG;

class TestLoop {
    final RNG shared;
    final RNG primary;
    final int iters;
    final Fraction pshared;
    final CyclicBarrier barrier;
    final boolean[] useShared;
    final int firstidx;

    public TestLoop(RNG sh, RNG pri, Fraction pshr, int it, CyclicBarrier br) {
        this.shared = sh;
        this.primary = pri;
        this.pshared = pshr;
        this.iters = it;
        this.barrier = br;
        this.firstidx = (int)this.primary.get();
        int num = (int)this.pshared.numerator();
        int denom = (int)this.pshared.denominator();
        if (num == 0 || this.primary == this.shared) {
            this.useShared = new boolean[1];
            this.useShared[0] = false;
        } else if (num >= denom) {
            this.useShared = new boolean[1];
            this.useShared[0] = true;
        } else {
            int i;
            int xfactor = 1024 / denom;
            if (xfactor < 1) {
                xfactor = 1;
            }
            this.useShared = new boolean[denom * xfactor];
            for (i = 0; i < num * xfactor; ++i) {
                this.useShared[i] = true;
            }
            for (i = num * xfactor; i < denom * xfactor; ++i) {
                this.useShared[i] = false;
            }
            for (i = 1; i < this.useShared.length; ++i) {
                int j = (int)(this.shared.next() & Integer.MAX_VALUE) % (i + 1);
                boolean tmp = this.useShared[i];
                this.useShared[i] = this.useShared[j];
                this.useShared[j] = tmp;
            }
        }
    }

    public Runnable testLoop() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                int itersPerBarrier = RNG.itersPerBarrier.get();
                try {
                    int delta = -1;
                    if (TestLoop.this.primary.getClass().equals(PrioritySemRNG.class)) {
                        delta = 2 - (int)(TestLoop.this.primary.get() % 5L);
                    }
                    Thread.currentThread().setPriority(5 + delta);
                    int nshared = (int)((double)TestLoop.this.iters * TestLoop.this.pshared.asDouble());
                    int nprimary = TestLoop.this.iters - nshared;
                    int idx = TestLoop.this.firstidx;
                    TestLoop.this.barrier.barrier();
                    int i = TestLoop.this.iters;
                    while (i > 0) {
                        ++idx;
                        if (i % itersPerBarrier == 0) {
                            TestLoop.this.primary.exchange();
                        } else {
                            RNG r;
                            if (nshared > 0 && TestLoop.this.useShared[idx % TestLoop.this.useShared.length]) {
                                --nshared;
                                r = TestLoop.this.shared;
                            } else {
                                --nprimary;
                                r = TestLoop.this.primary;
                            }
                            long rnd = r.next();
                            if (rnd % 2L == 0L && Thread.currentThread().isInterrupted()) {
                                return;
                            }
                        }
                        --i;
                    }
                    return;
                }
                catch (BrokenBarrierException ex) {
                    try {
                        TestLoop.this.barrier.barrier();
                        return;
                    }
                    catch (BrokenBarrierException ex2) {
                        return;
                    }
                    catch (InterruptedException ex3) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    finally {
                        Thread.currentThread().setPriority(5);
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return;
                }
                finally {
                    try {
                        TestLoop.this.barrier.barrier();
                    }
                    catch (BrokenBarrierException ex) {
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    finally {
                        Thread.currentThread().setPriority(5);
                    }
                }
            }
        };
    }
}

