/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.jboss.tools.buildmagic.task.ResolveProperties;

public class ProjectHelp
extends Task {
    protected PrintWriter out = new PrintWriter(System.out);
    protected List headers = new LinkedList();
    protected List footers = new LinkedList();

    public Heading createHeader() {
        Heading header = new Heading();
        this.headers.add(header);
        return header;
    }

    public Heading createFooter() {
        Heading footer = new Heading();
        this.footers.add(footer);
        return footer;
    }

    public void execute() throws BuildException {
        Hashtable targets = this.getProject().getTargets();
        LinkedList<String> names = new LinkedList<String>();
        int maxlen = 0;
        Iterator iter = targets.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Target target = (Target)targets.get(name);
            String desc = target.getDescription();
            if (desc == null) continue;
            int len = name.length();
            if (len > maxlen) {
                maxlen = len;
            }
            names.add(name);
        }
        this.printHeading(this.headers);
        this.printTargets(this.out, names, maxlen);
        this.printHeading(this.footers);
        this.out.flush();
    }

    protected void printHeading(List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Heading heading = (Heading)iter.next();
            heading.setProject(this.getProject());
            heading.print(this.out);
        }
    }

    protected String getDescription(String name) {
        Target target = (Target)this.getProject().getTargets().get(name);
        return target.getDescription();
    }

    protected void printTargets(PrintWriter out, List names, int maxlen) {
        String spaces = "    ";
        while (spaces.length() < maxlen) {
            spaces = spaces + spaces;
        }
        Collections.sort(names);
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            String pad = spaces.substring(0, maxlen - name.length() + 4);
            out.print("    ");
            out.print(name);
            out.print(pad);
            out.print(this.getDescription(name));
            out.println();
        }
    }

    protected class Heading {
        protected StringBuffer buff = new StringBuffer();
        protected Project project;

        protected Heading() {
        }

        public void setProject(Project project) {
            this.project = project;
        }

        public void setMessage(String text) {
            this.addText(text);
        }

        public void addText(String text) {
            this.buff.append(text);
        }

        public void print(PrintWriter out) {
            String msg = this.buff.toString();
            msg = ResolveProperties.subst(msg, this.project.getProperties(), false);
            out.println(msg);
        }
    }
}

