/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.junit;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.apache.ws.jaxme.xs.XSParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SyntaxTest
extends TestCase {
    public SyntaxTest(String pName) {
        super(pName);
    }

    protected void parseSyntax(File f) throws IOException, SAXException, ParserConfigurationException {
        XSParser xsp = new XSParser();
        InputSource isource = new InputSource(new FileInputStream(f));
        isource.setSystemId(f.toURL().toString());
        xsp.parseSyntax(isource);
    }

    protected void parseLogical(File f) throws IOException, SAXException, ParserConfigurationException {
        XSParser xsp = new XSParser();
        InputSource isource = new InputSource(new FileInputStream(f));
        isource.setSystemId(f.toURL().toString());
        xsp.parse(isource);
    }

    protected void parseSyntax(String s) throws IOException, SAXException, ParserConfigurationException {
        this.parseSyntax(new File(s));
    }

    protected void parseLogical(String s) throws IOException, SAXException, ParserConfigurationException {
        this.parseLogical(new File(s));
    }

    public void testStructureSyntax() throws Exception {
        this.parseSyntax("examples/xs/structures.xsd");
    }

    public void testDatatypesSyntax() throws Exception {
        this.parseSyntax("examples/xs/datatypes.xsd");
    }

    public void testXmlSyntax() throws Exception {
        this.parseSyntax("examples/xs/xml.xsd");
    }

    public void testStructureLogical() throws Exception {
        this.parseLogical("examples/xs/structures.xsd");
    }
}

