/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jms.integration;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.jboss.test.JBossTestCase;
import org.jboss.test.jms.integration.util.JMSAdmin;

public class MessagingIntegrationTestBase
extends JBossTestCase {
    public MessagingIntegrationTestBase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        String banner = "####################################################### Start test: " + this.getName();
        this.log.info((Object)banner);
    }

    public static JMSAdmin getDestManager() throws Exception {
        InitialContext ctx = new InitialContext();
        MBeanServerConnection server = (MBeanServerConnection)ctx.lookup("jmx/invoker/RMIAdaptor");
        ObjectName mgrName = new ObjectName("jboss.messaging:service=ServerPeer");
        JMSAdmin destMgr = (JMSAdmin)MBeanServerInvocationHandler.newProxyInstance(server, mgrName, JMSAdmin.class, false);
        return destMgr;
    }

    protected void tearDown() throws Exception {
        String banner = "####################################################### Stop test: " + this.getName();
        this.log.info((Object)banner);
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drainDestination(ConnectionFactory cf, Destination dest) throws Exception {
        Connection conn = null;
        try {
            conn = cf.createConnection();
            Session sess = conn.createSession(false, 1);
            MessageConsumer cons = sess.createConsumer(dest);
            Message m = null;
            conn.start();
            this.log.trace((Object)("Draining messages from " + dest));
            while ((m = cons.receive(500L)) != null) {
                this.log.trace((Object)"Drained message");
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drainSub(ConnectionFactory cf, Topic topic, String subName, String clientID) throws Exception {
        Connection conn = null;
        try {
            conn = cf.createConnection();
            conn.setClientID(clientID);
            Session sess = conn.createSession(false, 1);
            TopicSubscriber cons = sess.createDurableSubscriber(topic, subName);
            Message m = null;
            conn.start();
            this.log.trace((Object)("Draining messages from " + topic + ":" + subName));
            while ((m = cons.receive(500L)) != null) {
                this.log.trace((Object)"Drained message");
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}

