/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.interposition.resources.osi;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jts.interposition.ServerFactory;
import com.arjuna.ats.internal.jts.interposition.resources.arjuna.InterposedHierarchy;
import com.arjuna.ats.internal.jts.interposition.resources.arjuna.Interposition;
import com.arjuna.ats.internal.jts.interposition.resources.arjuna.ServerResource;
import com.arjuna.ats.internal.jts.interposition.resources.osi.OTIDMap;
import com.arjuna.ats.internal.jts.orbspecific.ControlImple;
import com.arjuna.ats.internal.jts.orbspecific.interposition.ServerControl;
import com.arjuna.ats.internal.jts.orbspecific.interposition.resources.arjuna.ServerNestedAction;
import com.arjuna.ats.internal.jts.orbspecific.interposition.resources.arjuna.ServerTopLevelAction;
import com.arjuna.ats.internal.jts.orbspecific.interposition.resources.osi.ServerOSINestedAction;
import com.arjuna.ats.internal.jts.orbspecific.interposition.resources.osi.ServerOSITopLevelAction;
import com.arjuna.ats.jts.logging.jtsLogger;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TransIdentity;

public class OSIInterposition
extends Interposition {
    private static OSIInterposition __list = new OSIInterposition();

    public static ControlImple create(PropagationContext context) throws SystemException {
        if (__list != null) {
            return __list.setupHierarchy(context);
        }
        return null;
    }

    public synchronized ControlImple setupHierarchy(PropagationContext context) throws SystemException {
        Uid theUid = OTIDMap.find(context.current.otid);
        InterposedHierarchy proxyAction = this.present(theUid);
        ControlImple controlPtr = null;
        controlPtr = proxyAction == null ? this.createHierarchy(context, theUid) : this.checkHierarchy(proxyAction, context);
        return controlPtr;
    }

    protected OSIInterposition() {
    }

    protected synchronized ControlImple createHierarchy(PropagationContext ctx, Uid currentUid) throws SystemException {
        int depth = ctx.parents.length;
        ServerResource action = null;
        Coordinator tmpCoord = null;
        Terminator tmpTerm = null;
        if (depth == 0) {
            tmpCoord = ctx.current.coord;
            tmpTerm = ctx.current.term;
        } else {
            tmpCoord = ctx.parents[depth - 1].coord;
            tmpTerm = ctx.parents[depth - 1].term;
        }
        if (tmpCoord == null) {
            return null;
        }
        ServerControl control = ServerFactory.create_transaction(currentUid, null, null, tmpCoord, tmpTerm, ctx.timeout);
        action = new ServerOSITopLevelAction(control, depth == 0);
        if (!action.valid()) {
            try {
                action.rollback();
                action = null;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new TRANSACTION_ROLLEDBACK();
        }
        InterposedHierarchy newElement = new InterposedHierarchy((ServerTopLevelAction)action);
        this._head.add(newElement);
        if (depth > 0) {
            ServerOSINestedAction nestedAction = null;
            for (int i = depth - 2; i >= 0; --i) {
                tmpCoord = ctx.parents[i].coord;
                tmpTerm = ctx.parents[i].term;
                control = ServerFactory.create_subtransaction(OTIDMap.find(ctx.parents[i].otid), tmpCoord, tmpTerm, control);
                nestedAction = new ServerOSINestedAction(control, false);
                if (!nestedAction.valid()) {
                    try {
                        nestedAction.rollback_subtransaction();
                        nestedAction = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw new TRANSACTION_ROLLEDBACK();
                }
                action.addChild(nestedAction);
                action = nestedAction;
            }
            tmpCoord = ctx.current.coord;
            tmpTerm = ctx.current.term;
            control = ServerFactory.create_subtransaction(OTIDMap.find(ctx.current.otid), tmpCoord, tmpTerm, control);
            nestedAction = new ServerOSINestedAction(control, true);
            if (!nestedAction.valid()) {
                try {
                    nestedAction.rollback_subtransaction();
                    nestedAction = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw new TRANSACTION_ROLLEDBACK();
            }
            action.addChild(nestedAction);
        }
        if (jtsLogger.logger.isDebugEnabled()) {
            this.compareHierarchies(ctx, newElement);
        }
        return control;
    }

    protected synchronized ControlImple checkHierarchy(InterposedHierarchy hier, PropagationContext context) {
        ServerControl control = null;
        ServerResource currentAction = hier.action();
        int depth = context.parents.length;
        int differenceIndex = -1;
        if (depth == 0) {
            ServerOSITopLevelAction tx2 = (ServerOSITopLevelAction)hier.action();
            tx2.interposeResource();
            control = tx2.control();
        } else {
            Uid currentUid;
            ServerNestedAction nestedAction = null;
            for (int i = depth - 2; i >= 0; --i) {
                nestedAction = currentAction.getChild(OTIDMap.find(context.parents[i].otid));
                if (nestedAction == null) {
                    differenceIndex = i;
                    break;
                }
                currentAction = nestedAction;
            }
            if (differenceIndex != -1) {
                control = currentAction.control();
                Coordinator tmpCoord = null;
                Terminator tmpTerm = null;
                for (int j = differenceIndex; j >= 0; --j) {
                    tmpCoord = context.parents[j].coord;
                    tmpTerm = context.parents[j].term;
                    control = ServerFactory.create_subtransaction(OTIDMap.find(context.parents[j].otid), tmpCoord, tmpTerm, control);
                    nestedAction = new ServerOSINestedAction(control, false);
                    if (!nestedAction.valid()) {
                        try {
                            ((ServerOSINestedAction)nestedAction).rollback();
                            nestedAction = null;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        throw new TRANSACTION_ROLLEDBACK();
                    }
                    currentAction.addChild((ServerOSINestedAction)nestedAction);
                    currentAction = nestedAction;
                }
            }
            if ((nestedAction = currentAction.getChild(currentUid = OTIDMap.find(context.current.otid))) == null) {
                control = currentAction.control();
                TransIdentity currentID = context.current;
                nestedAction = new ServerOSINestedAction(control = ServerFactory.create_subtransaction(currentUid, currentID.coord, currentID.term, control), true);
                if (!nestedAction.valid()) {
                    try {
                        ((ServerOSINestedAction)nestedAction).rollback();
                        nestedAction = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw new TRANSACTION_ROLLEDBACK();
                }
                currentAction.addChild((ServerOSINestedAction)nestedAction);
            } else {
                nestedAction.interposeResource();
                control = nestedAction.control();
            }
        }
        if (jtsLogger.logger.isDebugEnabled()) {
            this.compareHierarchies(context, hier);
        }
        return control;
    }
}

