/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.modified;

import org.jboss.deployers.vfs.spi.structure.modified.StructureCache;
import org.jboss.deployers.vfs.spi.structure.modified.SynchAdapter;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SynchVisitor
implements VirtualFileVisitor {
    protected final Logger log = Logger.getLogger(this.getClass());
    private VirtualFileFilter filter;
    private VisitorAttributes attributes;
    private StructureCache<Long> cache;
    private SynchAdapter synchAdapter;

    protected SynchVisitor(VisitorAttributes attributes, StructureCache<Long> cache, SynchAdapter synchAdapter) {
        this(null, attributes, cache, synchAdapter);
    }

    protected SynchVisitor(VirtualFileFilter filter, VisitorAttributes attributes, StructureCache<Long> cache, SynchAdapter synchAdapter) {
        if (cache == null) {
            throw new IllegalArgumentException("Null cache");
        }
        if (synchAdapter == null) {
            throw new IllegalArgumentException("Null synch adapter");
        }
        this.filter = filter;
        this.attributes = attributes != null ? attributes : VisitorAttributes.RECURSE_LEAVES_ONLY;
        this.cache = cache;
        this.synchAdapter = synchAdapter;
    }

    public VisitorAttributes getAttributes() {
        return this.attributes;
    }

    public void visit(VirtualFile file) {
        try {
            if (this.filter == null || this.filter.accepts(file)) {
                this.doVisit(file);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Exception synching file: " + file + ", cause: " + e));
        }
    }

    protected abstract void doVisit(VirtualFile var1) throws Exception;

    protected StructureCache<Long> getCache() {
        return this.cache;
    }

    protected SynchAdapter getSynchAdapter() {
        return this.synchAdapter;
    }
}

