/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.test.cluster.web.mocks;

import java.io.IOException;

import javax.servlet.ServletException;

import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;

/**
 * @author Brian Stansberry
 *
 */
public class RequestHandlerValve extends MockValve
{
   private RequestHandler requestHandler;
   
   public RequestHandlerValve(RequestHandler handler)
   {
      this.requestHandler = handler;
   }

   public String getInfo()
   {
      return "RequestHandlerValve";
   }

   public void invoke(Request request, Response response) throws IOException, ServletException
   {
      super.invoke(request, response);
      requestHandler.handleRequest(request, response);
   }

   public RequestHandler getRequestHandler()
   {
      return requestHandler;
   }

   public void setRequestHandler(RequestHandler requestHandler)
   {
      this.requestHandler = requestHandler;
   }

   @Override
   public void clear()
   {
       super.clear();
       
       if (this.requestHandler != null)
          this.requestHandler.clear();
   }

}
