/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.plugins.jmx;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementProperty;

/**
 * Stub class for the MemoryMXBean interface that is marked up with
 * management annotations.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
@ManagementObject(name=ManagementFactory.MEMORY_MXBEAN_NAME,
      isRuntime=true,
      componentType=@ManagementComponent(type="MBean", subtype="Platform"),
      targetInterface=MemoryMXBean.class)
public class MemoryMXBeanMO implements MemoryMXBean
{

   @ManagementOperation(description="Runs the garbage collector")
   public void gc()
   {
   }

   @ManagementProperty(description="object representing the heap memory usage.")
   public MemoryUsage getHeapMemoryUsage()
   {
      return null;
   }

   @ManagementProperty(description="object representing the non-heap memory usage.")
   public MemoryUsage getNonHeapMemoryUsage()
   {
      return null;
   }

   @ManagementProperty(description="the approximate number objects for which finalization is pending.")
   public int getObjectPendingFinalizationCount()
   {
      return 0;
   }

   @ManagementProperty(description="the verbose output flag for the memory system.")
   public boolean isVerbose()
   {
      return false;
   }

   public void setVerbose(boolean value)
   {
   }

}
