/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jaxb.intros;

import com.sun.xml.bind.v2.model.annotation.AbstractInlineAnnotationReaderImpl;
import com.sun.xml.bind.v2.model.annotation.Locatable;
import com.sun.xml.bind.v2.model.annotation.LocatableAnnotation;
import com.sun.xml.bind.v2.model.annotation.RuntimeAnnotationReader;
import com.sun.xml.bind.v2.model.annotation.RuntimeInlineAnnotationReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jaxb.intros.configmodel.ClassIntroConfig;
import org.jboss.jaxb.intros.configmodel.ClassMemberIntroConfig;
import org.jboss.jaxb.intros.configmodel.FieldIntroConfig;
import org.jboss.jaxb.intros.configmodel.JaxbIntros;
import org.jboss.jaxb.intros.configmodel.MethodIntroConfig;
import org.jboss.jaxb.intros.configmodel.XmlAccessorTypeIntro;
import org.jboss.jaxb.intros.configmodel.XmlAttributeIntro;
import org.jboss.jaxb.intros.configmodel.XmlElementIntro;
import org.jboss.jaxb.intros.configmodel.XmlRootElementIntro;
import org.jboss.jaxb.intros.configmodel.XmlTypeIntro;
import org.jboss.jaxb.intros.handlers.ClassValue;
import org.jboss.jaxb.intros.handlers.XmlAccessorTypeHandler;
import org.jboss.jaxb.intros.handlers.XmlAttributeHandler;
import org.jboss.jaxb.intros.handlers.XmlElementHandler;
import org.jboss.jaxb.intros.handlers.XmlRootElementHandler;
import org.jboss.jaxb.intros.handlers.XmlTypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntroductionsAnnotationReader
extends AbstractInlineAnnotationReaderImpl<Type, Class, Field, Method>
implements RuntimeAnnotationReader {
    private static final Log logger = LogFactory.getLog(IntroductionsAnnotationReader.class);
    private RuntimeAnnotationReader baseReader = new RuntimeInlineAnnotationReader();
    private JaxbIntros introductions;
    private static Map<String, Pattern> patternCache = new HashMap<String, Pattern>();

    public IntroductionsAnnotationReader(JaxbIntros jaxbIntros) {
        if (jaxbIntros == null) {
            throw new IllegalArgumentException("arg 'introductions' is null.");
        }
        this.introductions = jaxbIntros;
    }

    public <A extends Annotation> A getFieldAnnotation(Class<A> clazz, Field field, Locatable locatable) {
        Annotation annotation = this.getProxy(clazz, field);
        if (annotation != null) {
            return (A)annotation;
        }
        return (A)LocatableAnnotation.create(field.getAnnotation(clazz), (Locatable)locatable);
    }

    public boolean hasFieldAnnotation(Class<? extends Annotation> clazz, Field field) {
        FieldIntroConfig fieldIntroConfig = this.getFieldIntroConfig(field);
        if (fieldIntroConfig != null) {
            return this.isMemberAnnotationIntroAvailable(clazz, fieldIntroConfig);
        }
        return field.isAnnotationPresent(clazz);
    }

    public Annotation[] getAllFieldAnnotations(Field field, Locatable locatable) {
        return this.getAllAnnotations(field, locatable);
    }

    public <A extends Annotation> A getMethodAnnotation(Class<A> clazz, Method method, Locatable locatable) {
        Annotation annotation = this.getProxy(clazz, method);
        if (annotation != null) {
            return (A)annotation;
        }
        return (A)LocatableAnnotation.create(method.getAnnotation(clazz), (Locatable)locatable);
    }

    public boolean hasMethodAnnotation(Class<? extends Annotation> clazz, Method method) {
        MethodIntroConfig methodIntroConfig = this.getMethodIntroConfig(method);
        if (methodIntroConfig != null) {
            return this.isMemberAnnotationIntroAvailable(clazz, methodIntroConfig);
        }
        return method.isAnnotationPresent(clazz);
    }

    public Annotation[] getAllMethodAnnotations(Method method, Locatable locatable) {
        return this.getAllAnnotations(method, locatable);
    }

    public <A extends Annotation> A getMethodParameterAnnotation(Class<A> clazz, Method method, int n, Locatable locatable) {
        return (A)this.baseReader.getMethodParameterAnnotation(clazz, (Object)method, n, locatable);
    }

    public <A extends Annotation> A getClassAnnotation(Class<A> clazz, Class clazz2, Locatable locatable) {
        Annotation annotation = this.getProxy(clazz, clazz2);
        if (annotation != null) {
            return (A)annotation;
        }
        return (A)LocatableAnnotation.create(clazz2.getAnnotation(clazz), (Locatable)locatable);
    }

    public boolean hasClassAnnotation(Class clazz, Class<? extends Annotation> clazz2) {
        ClassIntroConfig classIntroConfig = this.getClassIntroConfig(clazz);
        if (classIntroConfig != null) {
            return this.isClassAnnotationIntroAvailable(clazz2, classIntroConfig);
        }
        return clazz.isAnnotationPresent(clazz2);
    }

    public <A extends Annotation> A getPackageAnnotation(Class<A> clazz, Class clazz2, Locatable locatable) {
        return (A)this.baseReader.getPackageAnnotation(clazz, (Object)clazz2, locatable);
    }

    public Class getClassValue(Annotation annotation, String string) {
        if (annotation instanceof ClassValue) {
            return ((ClassValue)((Object)annotation)).getClassValue(annotation, string);
        }
        return (Class)this.baseReader.getClassValue(annotation, string);
    }

    public Class[] getClassArrayValue(Annotation annotation, String string) {
        if (annotation instanceof ClassValue) {
            return ((ClassValue)((Object)annotation)).getClassArrayValue(annotation, string);
        }
        return (Class[])this.baseReader.getClassArrayValue(annotation, string);
    }

    protected String fullName(Method method) {
        return method.getDeclaringClass().getName() + '#' + method.getName();
    }

    private ClassIntroConfig getClassIntroConfig(Class clazz) {
        String string = clazz.getName();
        ClassIntroConfig classIntroConfig = null;
        for (ClassIntroConfig classIntroConfig2 : this.introductions.getClazz()) {
            if (classIntroConfig2.getName().equals(string)) {
                return classIntroConfig2;
            }
            if (classIntroConfig != null || !this.isRegexMatch(string, classIntroConfig2.getName())) continue;
            classIntroConfig = classIntroConfig2;
        }
        return classIntroConfig;
    }

    private FieldIntroConfig getFieldIntroConfig(Field field) {
        ClassIntroConfig classIntroConfig = this.getClassIntroConfig(field.getDeclaringClass());
        if (classIntroConfig != null) {
            String string = field.getName();
            for (FieldIntroConfig fieldIntroConfig : classIntroConfig.getField()) {
                if (fieldIntroConfig.getName().equals(string)) {
                    return fieldIntroConfig;
                }
                if (!this.isRegexMatch(string, fieldIntroConfig.getName())) continue;
                return fieldIntroConfig;
            }
        }
        return null;
    }

    private MethodIntroConfig getMethodIntroConfig(Method method) {
        ClassIntroConfig classIntroConfig = this.getClassIntroConfig(method.getDeclaringClass());
        if (classIntroConfig != null) {
            String string = method.getName();
            for (MethodIntroConfig methodIntroConfig : classIntroConfig.getMethod()) {
                if (methodIntroConfig.getName().equals(string)) {
                    return methodIntroConfig;
                }
                if (!this.isRegexMatch(string, methodIntroConfig.getName())) continue;
                return methodIntroConfig;
            }
        }
        return null;
    }

    private boolean isRegexMatch(String string, String string2) {
        Pattern pattern = patternCache.get(string2);
        if (pattern == null) {
            try {
                pattern = Pattern.compile(string2);
            }
            catch (Exception exception) {
                logger.warn((Object)("Error compiling '" + string2 + "' as a regular expression: " + exception.getMessage()));
                return false;
            }
            patternCache.put(string2, pattern);
        }
        return pattern.matcher(string).matches();
    }

    private Annotation getMemberAnnotationProxy(Class clazz, ClassMemberIntroConfig classMemberIntroConfig) {
        XmlElementIntro xmlElementIntro;
        Annotation annotation = null;
        if (clazz == XmlAttribute.class) {
            XmlAttributeIntro xmlAttributeIntro = classMemberIntroConfig.getXmlAttribute();
            if (xmlAttributeIntro != null) {
                annotation = XmlAttributeHandler.createProxy(xmlAttributeIntro);
            }
        } else if (clazz == XmlElement.class && (xmlElementIntro = classMemberIntroConfig.getXmlElement()) != null) {
            annotation = XmlElementHandler.createProxy(xmlElementIntro);
        }
        return annotation;
    }

    private Annotation getClassAnnotationProxy(Class clazz, ClassIntroConfig classIntroConfig) {
        XmlRootElementIntro xmlRootElementIntro;
        Annotation annotation = null;
        if (clazz == XmlAccessorType.class) {
            XmlAccessorTypeIntro xmlAccessorTypeIntro = classIntroConfig.getXmlAccessorType();
            if (xmlAccessorTypeIntro != null) {
                annotation = XmlAccessorTypeHandler.createProxy(xmlAccessorTypeIntro);
            }
        } else if (clazz == XmlType.class) {
            XmlTypeIntro xmlTypeIntro = classIntroConfig.getXmlType();
            if (xmlTypeIntro != null) {
                annotation = XmlTypeHandler.createProxy(xmlTypeIntro);
            }
        } else if (clazz == XmlRootElement.class && (xmlRootElementIntro = classIntroConfig.getXmlRootElement()) != null) {
            annotation = XmlRootElementHandler.createProxy(xmlRootElementIntro);
        }
        return annotation;
    }

    private boolean isMemberAnnotationIntroAvailable(Class<? extends Annotation> clazz, ClassMemberIntroConfig classMemberIntroConfig) {
        if (clazz == XmlAttribute.class) {
            return classMemberIntroConfig.getXmlAttribute() != null;
        }
        if (clazz == XmlElement.class) {
            return classMemberIntroConfig.getXmlElement() != null;
        }
        return false;
    }

    private boolean isClassAnnotationIntroAvailable(Class<? extends Annotation> clazz, ClassIntroConfig classIntroConfig) {
        if (clazz == XmlType.class) {
            return classIntroConfig.getXmlType() != null;
        }
        if (clazz == XmlAccessorType.class) {
            return classIntroConfig.getXmlAccessorType() != null;
        }
        if (clazz == XmlRootElement.class) {
            return classIntroConfig.getXmlRootElement() != null;
        }
        return false;
    }

    private Annotation[] getAllAnnotations(Member member, Locatable locatable) {
        Annotation[] annotationArray = ((AnnotatedElement)((Object)member)).getAnnotations();
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        for (int i = 0; i < annotationArray.length; ++i) {
            Class<?> clazz = annotationArray[i].getClass();
            if (clazz == XmlAttribute.class || clazz == XmlElement.class) continue;
            arrayList.add(LocatableAnnotation.create((Annotation)annotationArray[i], (Locatable)locatable));
        }
        ClassMemberIntroConfig classMemberIntroConfig = null;
        if (member instanceof Field) {
            classMemberIntroConfig = this.getFieldIntroConfig((Field)member);
        } else if (member instanceof Method) {
            classMemberIntroConfig = this.getMethodIntroConfig((Method)member);
        }
        if (classMemberIntroConfig != null) {
            this.addMemberAnnotation(XmlAttribute.class, classMemberIntroConfig, arrayList, member, locatable);
            this.addMemberAnnotation(XmlElement.class, classMemberIntroConfig, arrayList, member, locatable);
        }
        annotationArray = arrayList.toArray(new Annotation[arrayList.size()]);
        return annotationArray;
    }

    private void addMemberAnnotation(Class clazz, ClassMemberIntroConfig classMemberIntroConfig, List<Annotation> list, Member member, Locatable locatable) {
        Annotation annotation = this.getMemberAnnotationProxy(clazz, classMemberIntroConfig);
        if (annotation != null) {
            list.add(annotation);
        } else {
            annotation = ((AnnotatedElement)((Object)member)).getAnnotation(clazz);
            if (annotation != null) {
                list.add(LocatableAnnotation.create((Annotation)annotation, (Locatable)locatable));
            }
        }
    }

    private Annotation getProxy(Class clazz, Field field) {
        Annotation annotation;
        FieldIntroConfig fieldIntroConfig = this.getFieldIntroConfig(field);
        if (fieldIntroConfig != null && (annotation = this.getMemberAnnotationProxy(clazz, fieldIntroConfig)) != null) {
            return annotation;
        }
        return null;
    }

    private Annotation getProxy(Class clazz, Method method) {
        Annotation annotation;
        MethodIntroConfig methodIntroConfig = this.getMethodIntroConfig(method);
        if (methodIntroConfig != null && (annotation = this.getMemberAnnotationProxy(clazz, methodIntroConfig)) != null) {
            return annotation;
        }
        return null;
    }

    private Annotation getProxy(Class clazz, Class clazz2) {
        Annotation annotation;
        ClassIntroConfig classIntroConfig = this.getClassIntroConfig(clazz2);
        if (classIntroConfig != null && (annotation = this.getClassAnnotationProxy(clazz, classIntroConfig)) != null) {
            return annotation;
        }
        return null;
    }
}

