/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.umdm;

import com.sun.xml.bind.api.JAXBRIContext;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Set;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonBindingProvider;
import org.jboss.ws.core.CommonSOAPBinding;
import org.jboss.ws.core.binding.TypeMappingImpl;
import org.jboss.ws.core.jaxrpc.binding.JBossXBDeserializerFactory;
import org.jboss.ws.core.jaxrpc.binding.JBossXBSerializerFactory;
import org.jboss.ws.core.jaxrpc.binding.SOAPArrayDeserializerFactory;
import org.jboss.ws.core.jaxrpc.binding.SOAPArraySerializerFactory;
import org.jboss.ws.core.jaxws.JAXBContextCache;
import org.jboss.ws.core.jaxws.JAXBContextFactory;
import org.jboss.ws.core.jaxws.JAXBDeserializerFactory;
import org.jboss.ws.core.jaxws.JAXBSerializerFactory;
import org.jboss.ws.core.jaxws.client.DispatchBinding;
import org.jboss.ws.core.soap.Style;
import org.jboss.ws.core.soap.Use;
import org.jboss.ws.metadata.accessor.AccessorFactory;
import org.jboss.ws.metadata.accessor.AccessorFactoryCreator;
import org.jboss.ws.metadata.accessor.JAXBAccessorFactoryCreator;
import org.jboss.ws.metadata.config.CommonConfig;
import org.jboss.ws.metadata.config.Configurable;
import org.jboss.ws.metadata.config.ConfigurationProvider;
import org.jboss.ws.metadata.config.JBossWSConfigFactory;
import org.jboss.ws.metadata.umdm.EndpointConfigMetaData;
import org.jboss.ws.metadata.umdm.ExtensibleMetaData;
import org.jboss.ws.metadata.umdm.FeatureSet;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.InitalizableMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.TypeMappingMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;
import org.jboss.wsf.common.JavaUtils;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EndpointMetaData
extends ExtensibleMetaData
implements ConfigurationProvider,
InitalizableMetaData {
    private static Logger log = Logger.getLogger(EndpointMetaData.class);
    public static final Set<String> SUPPORTED_BINDINGS = new HashSet<String>();
    private ServiceMetaData serviceMetaData;
    private EndpointConfigMetaData configMetaData;
    private QName portName;
    private String bindingId;
    private QName portTypeName;
    private String seiName;
    private Class seiClass;
    private String authMethod;
    private Properties properties;
    private Style style;
    private Use use;
    private SOAPBinding.ParameterStyle parameterStyle;
    private Service.Mode serviceMode;
    private Type type;
    private List<OperationMetaData> operations = new ArrayList<OperationMetaData>();
    private Map<Method, OperationMetaData> opMetaDataCache = new HashMap<Method, OperationMetaData>();
    private List<Class> registeredTypes = new ArrayList<Class>();
    private FeatureSet features = new FeatureSet();
    private String documentation;
    private ConfigObservable configObservable = new ConfigObservable();
    private List<UnifiedPortComponentRefMetaData> serviceRefContrib = new ArrayList<UnifiedPortComponentRefMetaData>();
    private JAXBContextCache jaxbCache = new JAXBContextCache();
    private List<BindingCustomization> bindingCustomization = new ArrayList<BindingCustomization>();

    public EndpointMetaData(ServiceMetaData service, QName portName, QName portTypeName, Type type) {
        this.serviceMetaData = service;
        this.portName = portName;
        this.portTypeName = portTypeName;
        this.type = type;
        this.bindingId = "http://schemas.xmlsoap.org/wsdl/soap/http";
    }

    public ServiceMetaData getServiceMetaData() {
        return this.serviceMetaData;
    }

    public QName getPortName() {
        return this.portName;
    }

    public void setPortName(QName portName) {
        this.portName = portName;
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public abstract String getEndpointAddress();

    public abstract void setEndpointAddress(String var1);

    public String getBindingId() {
        return this.bindingId;
    }

    public void setBindingId(String bindingId) {
        if (!SUPPORTED_BINDINGS.contains(bindingId)) {
            throw new WSException("Unsupported binding: " + bindingId);
        }
        this.bindingId = bindingId;
    }

    public String getServiceEndpointInterfaceName() {
        return this.seiName;
    }

    public void setServiceEndpointInterfaceName(String seiName) {
        this.seiName = seiName;
        this.seiClass = null;
        UnifiedMetaData wsMetaData = this.serviceMetaData.getUnifiedMetaData();
        if (wsMetaData.isEagerInitialized()) {
            if (!UnifiedMetaData.isFinalRelease()) {
                log.warn((Object)"Set SEI name after eager initialization", (Throwable)new IllegalStateException());
            }
            this.initializeInternal();
        }
    }

    public ClassLoader getClassLoader() {
        return this.getServiceMetaData().getUnifiedMetaData().getClassLoader();
    }

    public Class getServiceEndpointInterface() {
        Class<?> tmpClass = this.seiClass;
        if (tmpClass == null && this.seiName != null) {
            try {
                ClassLoader classLoader = this.getClassLoader();
                tmpClass = classLoader.loadClass(this.seiName);
                if (this.serviceMetaData.getUnifiedMetaData().isEagerInitialized()) {
                    log.warn((Object)"Loading SEI after eager initialization");
                    this.seiClass = tmpClass;
                }
            }
            catch (ClassNotFoundException ex) {
                throw new WSException("Cannot load service endpoint interface: " + this.seiName, ex);
            }
        }
        return tmpClass;
    }

    public Use getEncodingStyle() {
        if (this.use == null) {
            this.use = Use.getDefaultUse();
            log.debug((Object)("Using default encoding style: " + this.use));
        }
        return this.use;
    }

    public void setEncodingStyle(Use value) {
        if (value != null && this.use != null && !this.use.equals(value)) {
            throw new WSException("Mixed encoding styles not supported");
        }
        log.trace((Object)("setEncodingStyle: " + value));
        this.use = value;
    }

    public Style getStyle() {
        if (this.style == null) {
            this.style = Style.getDefaultStyle();
            log.debug((Object)("Using default style: " + this.style));
        }
        return this.style;
    }

    public void setStyle(Style value) {
        if (value != null && this.style != null && !this.style.equals(value)) {
            throw new WSException("Mixed styles not supported");
        }
        log.trace((Object)("setStyle: " + value));
        this.style = value;
    }

    public SOAPBinding.ParameterStyle getParameterStyle() {
        if (this.parameterStyle == null) {
            this.parameterStyle = SOAPBinding.ParameterStyle.WRAPPED;
            log.debug((Object)("Using default parameter style: " + this.parameterStyle));
        }
        return this.parameterStyle;
    }

    public void setParameterStyle(SOAPBinding.ParameterStyle value) {
        if (value != null && this.parameterStyle != null && !this.parameterStyle.equals((Object)value)) {
            throw new WSException("Mixed SOAP parameter styles not supported");
        }
        log.debug((Object)("setParameterStyle: " + value));
        this.parameterStyle = value;
    }

    public Service.Mode getServiceMode() {
        return this.serviceMode;
    }

    public void setServiceMode(Service.Mode serviceMode) {
        this.serviceMode = serviceMode;
    }

    public Type getType() {
        return this.type;
    }

    public Collection<BindingCustomization> getBindingCustomizations() {
        return this.bindingCustomization;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public Properties getProperties() {
        if (null == this.properties) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public <T extends WebServiceFeature> T getFeature(Class<T> key) {
        return this.features.getFeature(key);
    }

    public <T extends WebServiceFeature> boolean isFeatureEnabled(Class<T> key) {
        return this.features.isFeatureEnabled(key);
    }

    public FeatureSet getFeatures() {
        return this.features;
    }

    public void addFeature(WebServiceFeature feature) {
        this.features.addFeature(feature);
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public List<OperationMetaData> getOperations() {
        return new ArrayList<OperationMetaData>(this.operations);
    }

    public OperationMetaData getOperation(QName xmlName) {
        OperationMetaData opMetaData = null;
        for (OperationMetaData aux : this.operations) {
            QName opQName = aux.getQName();
            String javaName = aux.getJavaName();
            if (!opQName.equals(xmlName) || javaName.endsWith("Async")) continue;
            if (opMetaData == null) {
                opMetaData = aux;
                continue;
            }
            throw new WSException("Cannot uniquely indentify operation: " + xmlName);
        }
        if (opMetaData == null && this.getStyle() == Style.DOCUMENT) {
            for (OperationMetaData auxOperation : this.operations) {
                ParameterMetaData paramMetaData = null;
                for (ParameterMetaData auxParam : auxOperation.getParameters()) {
                    ParameterMode mode = auxParam.getMode();
                    if (auxParam.isInHeader() || mode == ParameterMode.OUT) continue;
                    paramMetaData = auxParam;
                    break;
                }
                if (paramMetaData == null || !paramMetaData.getXmlName().equals(xmlName)) continue;
                if (opMetaData == null) {
                    opMetaData = auxOperation;
                    continue;
                }
                throw new WSException("Cannot uniquely indentify operation: " + xmlName);
            }
        }
        return opMetaData;
    }

    public OperationMetaData getOperation(Method method) {
        OperationMetaData opMetaData;
        if (this.opMetaDataCache.size() == 0) {
            log.warn((Object)"Access to empty operation meta data cache, reinitializing");
            this.initializeInternal();
        }
        if ((opMetaData = this.opMetaDataCache.get(method)) == null) {
            for (OperationMetaData aux : this.operations) {
                boolean doesMatch = aux.getJavaMethod().equals(method);
                if (!doesMatch && method.getName().endsWith("Async")) {
                    String name = method.getName();
                    name = name.substring(0, name.length() - 5);
                    doesMatch = aux.getJavaName().equals(name);
                }
                if (!doesMatch) continue;
                this.opMetaDataCache.put(method, aux);
                opMetaData = aux;
                break;
            }
        }
        return opMetaData;
    }

    public void addOperation(OperationMetaData opMetaData) {
        this.operations.add(opMetaData);
    }

    public void clearOperations() {
        this.operations.clear();
    }

    public void addHandlers(List<HandlerMetaData> configHandlers) {
        this.getEndpointConfigMetaData().addHandlers(configHandlers);
    }

    public void addHandler(HandlerMetaData handler) {
        this.getEndpointConfigMetaData().addHandler(handler);
    }

    public void clearHandlers() {
        this.getEndpointConfigMetaData().clearHandlers();
    }

    public List<HandlerMetaData> getHandlerMetaData(UnifiedHandlerMetaData.HandlerType type) {
        return this.getEndpointConfigMetaData().getHandlerMetaData(type);
    }

    public boolean isHandlersInitialized() {
        return this.getEndpointConfigMetaData().isHandlersInitialized();
    }

    public void setHandlersInitialized(boolean flag) {
        this.getEndpointConfigMetaData().setHandlersInitialized(flag);
    }

    public void validate() {
        this.getEndpointConfigMetaData().validate();
        for (OperationMetaData opMetaData : this.operations) {
            opMetaData.validate();
        }
    }

    @Override
    public void eagerInitialize() {
        this.initializeInternal();
    }

    private void initializeInternal() {
        this.seiClass = null;
        this.getEndpointConfigMetaData().initializeInternal();
        this.eagerInitializeOperations();
        this.eagerInitializeTypes();
        this.eagerInitializeAccessors();
        this.eagerInitializeJAXBContextCache();
    }

    private void eagerInitializeOperations() {
        this.seiClass = this.getServiceEndpointInterface();
        if (this.seiClass != null) {
            ArrayList<Method> unsynchronizedMethods = new ArrayList<Method>();
            unsynchronizedMethods.addAll(Arrays.asList(this.seiClass.getMethods()));
            for (OperationMetaData opMetaData : this.operations) {
                opMetaData.eagerInitialize(unsynchronizedMethods);
                Method method = opMetaData.getJavaMethod();
                if (method == null) continue;
                this.opMetaDataCache.put(method, opMetaData);
                unsynchronizedMethods.remove(method);
            }
        }
    }

    private void eagerInitializeTypes() {
        TypeMappingImpl typeMapping = this.serviceMetaData.getTypeMapping();
        List<TypeMappingMetaData> typeMappings = this.serviceMetaData.getTypesMetaData().getTypeMappings();
        this.registeredTypes = new ArrayList<Class>(typeMappings.size());
        for (TypeMappingMetaData tmMetaData : typeMappings) {
            String javaTypeName = tmMetaData.getJavaTypeName();
            QName xmlType = tmMetaData.getXmlType();
            if (xmlType == null) continue;
            List<Class> types = typeMapping.getJavaTypes(xmlType);
            boolean registered = false;
            for (Class current : types) {
                if (!current.getName().equals(javaTypeName)) continue;
                this.registeredTypes.add(current);
                registered = true;
                break;
            }
            if (registered) continue;
            try {
                ClassLoader classLoader = this.getClassLoader();
                Class javaType = JavaUtils.loadJavaType((String)javaTypeName, (ClassLoader)classLoader);
                if (JavaUtils.isPrimitive((String)javaTypeName)) {
                    javaType = JavaUtils.getWrapperType((Class)javaType);
                }
                this.registeredTypes.add(javaType);
                if (this.getEncodingStyle() == Use.ENCODED && javaType.isArray()) {
                    typeMapping.register(javaType, xmlType, new SOAPArraySerializerFactory(), new SOAPArrayDeserializerFactory());
                    continue;
                }
                if (this.getType() == Type.JAXWS) {
                    typeMapping.register(javaType, xmlType, new JAXBSerializerFactory(), new JAXBDeserializerFactory());
                    continue;
                }
                typeMapping.register(javaType, xmlType, new JBossXBSerializerFactory(), new JBossXBDeserializerFactory());
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)("Cannot load class for type: " + xmlType + "," + javaTypeName));
            }
        }
    }

    private void eagerInitializeAccessors() {
        boolean useJAXBAccessorFactory = false;
        ArrayList<Class> types = new ArrayList<Class>();
        for (OperationMetaData opMetaData : this.operations) {
            for (ParameterMetaData paramMetaData : opMetaData.getParameters()) {
                AccessorFactoryCreator factoryCreator = paramMetaData.getAccessorFactoryCreator();
                if (factoryCreator instanceof JAXBAccessorFactoryCreator) {
                    useJAXBAccessorFactory = true;
                }
                types.add(paramMetaData.getJavaType());
            }
            ParameterMetaData retParam = opMetaData.getReturnParameter();
            if (retParam == null) continue;
            AccessorFactoryCreator factoryCreator = retParam.getAccessorFactoryCreator();
            if (factoryCreator instanceof JAXBAccessorFactoryCreator) {
                useJAXBAccessorFactory = true;
            }
            types.add(retParam.getJavaType());
        }
        JAXBRIContext jaxbCtx = null;
        if (useJAXBAccessorFactory) {
            Class[] typeArr = new Class[types.size()];
            jaxbCtx = (JAXBRIContext)JAXBContextFactory.newInstance().createContext(types.toArray(typeArr));
        }
        for (OperationMetaData opMetaData : this.operations) {
            for (ParameterMetaData paramMetaData : opMetaData.getParameters()) {
                this.createAccessor(paramMetaData, jaxbCtx);
            }
            ParameterMetaData retParam = opMetaData.getReturnParameter();
            if (retParam == null) continue;
            this.createAccessor(retParam, jaxbCtx);
        }
    }

    private void eagerInitializeJAXBContextCache() {
        if ("true".equalsIgnoreCase(System.getProperty("org.jboss.ws.eagerInitializeJAXBContextCache"))) {
            log.debug((Object)"Initializing JAXBContext cache...");
            BindingCustomization bindingCustomization = null;
            if (this instanceof ServerEndpointMetaData) {
                bindingCustomization = (BindingCustomization)((ServerEndpointMetaData)this).getEndpoint().getAttachment(BindingCustomization.class);
            }
            try {
                Class[] classes = this.getRegisteredTypes().toArray(new Class[0]);
                JAXBContext context = JAXBContextFactory.newInstance().createContext(classes, bindingCustomization);
                this.jaxbCache.add(classes, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void createAccessor(ParameterMetaData paramMetaData, JAXBRIContext jaxbCtx) {
        AccessorFactoryCreator factoryCreator = paramMetaData.getAccessorFactoryCreator();
        if (factoryCreator instanceof JAXBAccessorFactoryCreator) {
            ((JAXBAccessorFactoryCreator)factoryCreator).setJAXBContext(jaxbCtx);
        }
        if (paramMetaData.getWrappedParameters() != null) {
            AccessorFactory factory = factoryCreator.create(paramMetaData);
            for (WrappedParameter wParam : paramMetaData.getWrappedParameters()) {
                wParam.setAccessor(factory.create(wParam));
            }
        }
    }

    @Override
    public void configure(Configurable configurable) {
        CommonConfig config = this.getConfig();
        if (configurable instanceof CommonBindingProvider) {
            log.debug((Object)"Configure SOAPBinding");
            if (config.hasFeature("http://org.jboss.ws/mtom")) {
                CommonBindingProvider provider = (CommonBindingProvider)configurable;
                ((CommonSOAPBinding)provider.getCommonBinding()).setMTOMEnabled(true);
                log.debug((Object)("Enable MTOM on endpoint " + this.getPortName()));
            }
        } else if (configurable instanceof DispatchBinding) {
            DispatchBinding dpb = (DispatchBinding)configurable;
            dpb.setValidateDispatch(config.hasFeature("http://org.jboss.ws/dispatch/validate"));
        }
    }

    public UnifiedVirtualFile getRootFile() {
        return this.getServiceMetaData().getUnifiedMetaData().getRootFile();
    }

    @Override
    public void registerConfigObserver(Configurable observer) {
        this.configObservable.addObserver(observer);
    }

    public JAXBContextCache getJaxbCache() {
        return this.jaxbCache;
    }

    @Override
    public String getConfigFile() {
        return this.getEndpointConfigMetaData().getConfigFile();
    }

    @Override
    public String getConfigName() {
        return this.getEndpointConfigMetaData().getConfigName();
    }

    public EndpointConfigMetaData getEndpointConfigMetaData() {
        if (this.configMetaData == null) {
            this.configMetaData = new EndpointConfigMetaData(this);
        }
        return this.configMetaData;
    }

    public CommonConfig getConfig() {
        EndpointConfigMetaData ecmd = this.getEndpointConfigMetaData();
        CommonConfig config = ecmd.getConfig();
        if (config == null) {
            this.initEndpointConfigMetaData(ecmd, null);
            config = ecmd.getConfig();
        }
        return config;
    }

    @Override
    public void setConfigName(String configName) {
        this.setConfigNameInternal(configName, null);
    }

    @Override
    public void setConfigName(String configName, String configFile) {
        this.setConfigNameInternal(configName, configFile);
    }

    private void setConfigNameInternal(String configName, String configFile) {
        if (configName == null) {
            throw new IllegalArgumentException("Config name cannot be null");
        }
        if (configFile == null) {
            configFile = this.getEndpointConfigMetaData().getConfigFile();
        }
        if (!configName.equals(this.getEndpointConfigMetaData().getConfigName()) || !configFile.equals(this.getEndpointConfigMetaData().getConfigFile())) {
            log.debug((Object)("Reconfiguration forced, new config is '" + configName + "' file is '" + configFile + "'"));
            this.configMetaData = this.createEndpointConfigMetaData(configName, configFile);
            this.configObservable.doNotify(configName);
        }
    }

    protected EndpointConfigMetaData createEndpointConfigMetaData(String configName, String configFile) {
        EndpointConfigMetaData ecmd = new EndpointConfigMetaData(this);
        ecmd.setConfigName(configName);
        ecmd.setConfigFile(configFile);
        this.initEndpointConfigMetaData(ecmd, this.configMetaData);
        return ecmd;
    }

    public void initEndpointConfig() {
        EndpointConfigMetaData ecmd = this.getEndpointConfigMetaData();
        this.initEndpointConfigMetaData(ecmd, ecmd);
    }

    private void initEndpointConfigMetaData(EndpointConfigMetaData toInitialise, EndpointConfigMetaData base) {
        String configName = toInitialise.getConfigName();
        String configFile = toInitialise.getConfigFile();
        log.debug((Object)("Create new config [name=" + configName + ",file=" + configFile + "]"));
        JBossWSConfigFactory factory = JBossWSConfigFactory.newInstance();
        CommonConfig config = factory.getConfig(this.getRootFile(), configName, configFile);
        toInitialise.setConfig(config);
        toInitialise.configHandlerMetaData();
    }

    public List<Class> getRegisteredTypes() {
        return Collections.unmodifiableList(this.registeredTypes);
    }

    public List<UnifiedPortComponentRefMetaData> getServiceRefContrib() {
        return this.serviceRefContrib;
    }

    public boolean matches(UnifiedPortComponentRefMetaData pcRef) {
        String seiName = pcRef.getServiceEndpointInterface();
        QName portName = pcRef.getPortQName();
        boolean match = seiName != null && portName != null ? this.getServiceEndpointInterfaceName().equals(seiName) && this.getPortName().equals(portName) : this.getServiceEndpointInterfaceName().equals(seiName) || this.getPortName().equals(portName);
        return match;
    }

    static {
        SUPPORTED_BINDINGS.add("http://schemas.xmlsoap.org/wsdl/soap/http");
        SUPPORTED_BINDINGS.add("http://www.w3.org/2003/05/soap/bindings/HTTP/");
        SUPPORTED_BINDINGS.add("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
        SUPPORTED_BINDINGS.add("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
        SUPPORTED_BINDINGS.add("http://www.w3.org/2004/08/wsdl/http");
    }

    class ConfigObservable
    extends Observable {
        private ReferenceQueue<WeakReference<Observer>> queue = new ReferenceQueue();
        private List<WeakReference<Observer>> observer = new ArrayList<WeakReference<Observer>>();

        ConfigObservable() {
        }

        public void doNotify(Object object) {
            this.setChanged();
            this.notifyObservers(object);
        }

        public synchronized void addObserver(Observer o) {
            this.clearCollected();
            this.observer.add(new WeakReference<WeakReference<Observer>>((WeakReference<Observer>)((Object)o), this.queue));
        }

        public synchronized void deleteObserver(Observer o) {
            this.clearCollected();
            for (WeakReference<Observer> w : this.observer) {
                Observer tmp = (Observer)w.get();
                if (tmp == null || !tmp.equals(o)) continue;
                this.observer.remove(o);
                break;
            }
        }

        public void notifyObservers() {
            this.notifyObservers(null);
        }

        public void notifyObservers(Object arg) {
            this.clearCollected();
            if (this.hasChanged()) {
                for (WeakReference<Observer> w : this.observer) {
                    Observer tmp = (Observer)w.get();
                    if (tmp == null) continue;
                    tmp.update(this, arg);
                }
            }
        }

        private void clearCollected() {
            Reference<WeakReference<Observer>> ref;
            while ((ref = this.queue.poll()) != null) {
                this.observer.remove(ref);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        JAXRPC,
        JAXWS;

    }
}

