/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.hibernate;

import java.util.Collection;
import xdoclet.TemplateSubTask;
import xdoclet.XDocletException;
import xdoclet.modules.hibernate.HibernateProperties;
import xdoclet.modules.hibernate.XDocletModulesHibernateMessages;
import xdoclet.tagshandler.PackageTagsHandler;
import xdoclet.util.Translator;
import xjavadoc.XClass;

public class FactoryClassSubTask
extends TemplateSubTask
implements HibernateProperties {
    private static String DEFAULT_TEMPLATE_FILE = "resources/hibernate-factory.xdt";
    private static String GENERATED_FILE_NAME = "HibernateFactory.java";
    private String dataSource;
    private String dialect;
    private String driver;
    private String username;
    private String password;
    private String factoryClass;
    private boolean useJndiFactory = false;
    private String jndiName;
    private String jdbcUrl;
    private String poolSize;

    public FactoryClassSubTask() {
        this.setSubTaskName("factoryclass");
        this.setHavingClassTag("hibernate.class");
        this.setTemplateURL(this.getClass().getResource(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(GENERATED_FILE_NAME);
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getDialect() {
        return this.dialect;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getFactoryClass() {
        return this.factoryClass;
    }

    public boolean isUseJndiFactory() {
        return this.useJndiFactory;
    }

    public Collection getJndiProperties() {
        throw new UnsupportedOperationException("FactoryClassSubTask does not have a jndiProperties attribute.");
    }

    public Collection getOtherMappings() {
        throw new UnsupportedOperationException("FactoryClassSubTask doesn't have other mappings");
    }

    public Collection getOtherProperties() {
        throw new UnsupportedOperationException("FactoryClassSubTask does not have an otherProperties attribute.");
    }

    public String getTransactionManagerStrategy() {
        throw new UnsupportedOperationException("FactoryClassSubTask does not have a transactionManagerStrategy attribute.");
    }

    public String getUserTransactionName() {
        throw new UnsupportedOperationException("FactoryClassSubTask does not have a userTransactionName attribute.");
    }

    public String getUserName() {
        return this.username;
    }

    public boolean getUseOuterJoin() {
        throw new UnsupportedOperationException("FactoryClassSubTask does not have a useOuterJoin attribute.");
    }

    public boolean getShowSql() {
        throw new UnsupportedOperationException("FactoryClassSubTask does not have a showSql attribute.");
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getPoolSize() {
        return this.poolSize;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setPoolSize(String poolSize) {
        this.poolSize = poolSize;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setFactoryClass(String factoryClass) {
        this.factoryClass = factoryClass;
    }

    public void setUseJndiFactory(boolean useJndiFactory) {
        this.useJndiFactory = useJndiFactory;
    }

    public void validateOptions() throws XDocletException {
        super.validateOptions();
        if (this.getFactoryClass() == null) {
            throw new XDocletException(Translator.getString(XDocletModulesHibernateMessages.class, (String)"FACTORY_NAME_REQUIRED"));
        }
    }

    public void execute() throws XDocletException {
        this.setDestinationFile(PackageTagsHandler.packageNameAsPathFor((String)this.factoryClass) + ".java");
        this.startProcess();
    }

    protected String getGeneratedFileName(XClass clazz) throws XDocletException {
        return PackageTagsHandler.packageNameAsPathFor((String)this.factoryClass) + ".java";
    }

    protected void engineStarted() throws XDocletException {
        System.out.println(Translator.getString(XDocletModulesHibernateMessages.class, (String)"GENERATING_HIBERNATE_FACTORY_CLASS"));
    }
}

