/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static Class<?> loadClass(String name) {
        if (System.getSecurityManager() == null) {
            return LoadClassAction.NON_PRIVILEGED.loadClass(name);
        }
        return LoadClassAction.PRIVILEGED.loadClass(name);
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
    }

    static Constructor<?>[] getDeclaredConstructors(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return GetDeclaredConstructorsAction.NON_PRIVILEGED.getDeclaredConstructors(clazz);
        }
        return GetDeclaredConstructorsAction.PRIVILEGED.getDeclaredConstructors(clazz);
    }

    static Method[] getDeclaredMethods(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return GetDeclaredMethodsAction.NON_PRIVILEGED.getDeclaredMethods(clazz);
        }
        return GetDeclaredMethodsAction.PRIVILEGED.getDeclaredMethods(clazz);
    }

    static Field[] getDeclaredFields(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return GetDeclaredFieldsAction.NON_PRIVILEGED.getDeclaredFields(clazz);
        }
        return GetDeclaredFieldsAction.PRIVILEGED.getDeclaredFields(clazz);
    }

    static ClassLoader getClassLoader(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return GetClassLoaderAction.NON_PRIVILEGED.getClassLoader(clazz);
        }
        return GetClassLoaderAction.PRIVILEGED.getClassLoader(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GetClassLoaderAction {
        public static final GetClassLoaderAction NON_PRIVILEGED = new GetClassLoaderAction(){

            @Override
            public ClassLoader getClassLoader(Class<?> clazz) {
                return clazz.getClassLoader();
            }
        };
        public static final GetClassLoaderAction PRIVILEGED = new GetClassLoaderAction(){

            @Override
            public ClassLoader getClassLoader(final Class<?> clazz) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return clazz.getClassLoader();
                    }
                });
            }
        };

        public ClassLoader getClassLoader(Class<?> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GetDeclaredFieldsAction {
        public static final GetDeclaredFieldsAction NON_PRIVILEGED = new GetDeclaredFieldsAction(){

            @Override
            public Field[] getDeclaredFields(Class<?> clazz) {
                return clazz.getDeclaredFields();
            }
        };
        public static final GetDeclaredFieldsAction PRIVILEGED = new GetDeclaredFieldsAction(){

            @Override
            public Field[] getDeclaredFields(final Class<?> clazz) {
                return AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

                    @Override
                    public Field[] run() {
                        return clazz.getDeclaredFields();
                    }
                });
            }
        };

        public Field[] getDeclaredFields(Class<?> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GetDeclaredMethodsAction {
        public static final GetDeclaredMethodsAction NON_PRIVILEGED = new GetDeclaredMethodsAction(){

            @Override
            public Method[] getDeclaredMethods(Class<?> clazz) {
                return clazz.getDeclaredMethods();
            }
        };
        public static final GetDeclaredMethodsAction PRIVILEGED = new GetDeclaredMethodsAction(){

            @Override
            public Method[] getDeclaredMethods(final Class<?> clazz) {
                return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                    @Override
                    public Method[] run() {
                        return clazz.getDeclaredMethods();
                    }
                });
            }
        };

        public Method[] getDeclaredMethods(Class<?> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GetDeclaredConstructorsAction {
        public static final GetDeclaredConstructorsAction NON_PRIVILEGED = new GetDeclaredConstructorsAction(){

            @Override
            public Constructor<?>[] getDeclaredConstructors(Class<?> clazz) {
                return clazz.getDeclaredConstructors();
            }
        };
        public static final GetDeclaredConstructorsAction PRIVILEGED = new GetDeclaredConstructorsAction(){

            @Override
            public Constructor<?>[] getDeclaredConstructors(final Class<?> clazz) {
                return AccessController.doPrivileged(new PrivilegedAction<Constructor<?>[]>(){

                    @Override
                    public Constructor<?>[] run() {
                        return clazz.getDeclaredConstructors();
                    }
                });
            }
        };

        public Constructor<?>[] getDeclaredConstructors(Class<?> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetContextClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        public static GetContextClassLoaderAction INSTANCE = new GetContextClassLoaderAction();

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface LoadClassAction {
        public static final LoadClassAction PRIVILEGED = new LoadClassAction(){

            @Override
            public Class<?> loadClass(final String name) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                        @Override
                        public Class<?> run() throws Exception {
                            return Thread.currentThread().getContextClassLoader().loadClass(name);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException("Unable to load class " + name, e.getException());
                }
            }
        };
        public static final LoadClassAction NON_PRIVILEGED = new LoadClassAction(){

            @Override
            public Class<?> loadClass(String name) {
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unable to load class " + name, e);
                }
            }
        };

        public Class<?> loadClass(String var1);
    }
}

