/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.env;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import xdoclet.XDocletException;
import xdoclet.modules.ejb.EjbTagsHandler;
import xdoclet.modules.ejb.XDocletModulesEjbMessages;
import xdoclet.modules.ejb.env.EnvTagsHandler;
import xdoclet.modules.ejb.home.HomeTagsHandler;
import xdoclet.modules.ejb.intf.InterfaceTagsHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xjavadoc.XClass;
import xjavadoc.XDoc;
import xjavadoc.XTag;

public class EnvEjbRefTagsHandler
extends EnvTagsHandler {
    private String referringClassId;
    private Map already = new HashMap();
    private XClass refedEJBClass;

    public String ejbRefId() throws XDocletException {
        return this.referringClassId + '_' + EjbTagsHandler.getEjbIdFor(this.refedEJBClass);
    }

    public void forAllEjbRefs(String template, Properties attributes) throws XDocletException {
        this.already.clear();
        if (attributes.getProperty("tagName") == null) {
            attributes.setProperty("tagName", "ejb.ejb-ref");
        }
        this.forTags(template, attributes, true, true, true);
        this.already.clear();
    }

    public void forAllEjbRefMembers(String template, Properties attributes) throws XDocletException {
        this.already.clear();
        if (attributes.getProperty("tagName") == null) {
            attributes.setProperty("tagName", "ejb.ejb-ref");
        }
        this.forTags(template, attributes, false, true, true);
        this.already.clear();
    }

    public void forAllEjbRefMethods(String template, Properties attributes) throws XDocletException {
        this.already.clear();
        if (attributes.getProperty("tagName") == null) {
            attributes.setProperty("tagName", "ejb.ejb-ref");
        }
        this.forTags(template, attributes, false, true, false);
        this.already.clear();
    }

    public String ejbRefJndiName() throws XDocletException {
        String ejbRefJndiName = null;
        String jndiNameParameter = this.currentTag.getAttributeValue("jndi-name");
        if (jndiNameParameter != null) {
            ejbRefJndiName = jndiNameParameter;
        } else {
            String refed_ejb_name = this.currentTag.getAttributeValue("ejb-name");
            if (refed_ejb_name == null) {
                throw new XDocletException("No ejb-name attribute found in ejb-ref specified in bean " + EnvEjbRefTagsHandler.getCurrentClass());
            }
            XClass refed_clazz = this.findEjb(refed_ejb_name);
            String ejb_type = EjbTagsHandler.isLocalEjb(refed_clazz) ? "local" : "remote";
            ejbRefJndiName = HomeTagsHandler.getJndiNameOfTypeFor(ejb_type, refed_clazz);
        }
        return ejbRefJndiName;
    }

    public void ifLocalEjbRef(String template) throws XDocletException {
        if (this.isLocalEjbRef(this.currentTag)) {
            this.generate(template);
        }
    }

    public void ifRemoteEjbRef(String template) throws XDocletException {
        if (this.isRemoteEjbRef(this.currentTag)) {
            this.generate(template);
        }
    }

    public String name(Properties attributes) throws XDocletException {
        if (this.currentMember == null) {
            return EjbTagsHandler.ejbRefName(this.currentTag, this.refedEJBClass);
        }
        attributes.setProperty("paramName", "ref-name");
        return super.name(attributes);
    }

    public String homeInterface() throws XDocletException {
        String intf;
        if ("ejb.ejb-external-ref".equals(this.currentTag.getName())) {
            intf = this.currentTag.getAttributeValue("home");
            if (intf == null) {
                EnvEjbRefTagsHandler.mandatoryParamNotFound((XDoc)this.currentTag.getDoc(), (String)"home", (String)"ejb.ejb-external-ref");
            }
        } else {
            String type = this.isRemoteEjbRef(this.currentTag) ? "remote" : "local";
            intf = HomeTagsHandler.getHomeInterface(type, EnvEjbRefTagsHandler.getCurrentClass());
        }
        return intf;
    }

    public String componentInterface() throws XDocletException {
        String intf;
        if ("ejb.ejb-external-ref".equals(this.currentTag.getName())) {
            intf = this.currentTag.getAttributeValue("business");
            if (intf == null) {
                intf = this.currentTag.getAttributeValue("remote");
            }
            if (intf == null) {
                EnvEjbRefTagsHandler.mandatoryParamNotFound((XDoc)this.currentTag.getDoc(), (String)"business", (String)"ejb.ejb-external-ref");
            }
        } else {
            String type = this.isRemoteEjbRef(this.currentTag) ? "remote" : "local";
            intf = InterfaceTagsHandler.getComponentInterface(type, EnvEjbRefTagsHandler.getCurrentClass());
        }
        return intf;
    }

    protected boolean isLocalEjbRef(XTag ejbRefTag) throws XDocletException {
        String viewTypeParameter = ejbRefTag.getAttributeValue("view-type");
        if (viewTypeParameter == null) {
            return EjbTagsHandler.isLocalEjb(this.refedEJBClass) && !EjbTagsHandler.isRemoteEjb(this.refedEJBClass);
        }
        return "local".equals(viewTypeParameter);
    }

    protected boolean isRemoteEjbRef(XTag ejbRefTag) throws XDocletException {
        return !this.isLocalEjbRef(ejbRefTag);
    }

    protected void doGenerate(String template) throws XDocletException {
        String refName;
        Log log = LogUtil.getLog(EnvEjbRefTagsHandler.class, (String)"doGenerate");
        this.storeReferringClassId();
        String ejbNameAttribute = this.currentTag.getAttributeValue("ejb-name");
        if ("ejb.ejb-ref".equals(this.currentTag.getName())) {
            if (ejbNameAttribute == null || ejbNameAttribute.length() < 1) {
                EnvEjbRefTagsHandler.mandatoryParamNotFound((XDoc)this.currentTag.getDoc(), (String)"ejb-name", (String)"ejb.ejb-ref");
            }
            this.refedEJBClass = this.findEjb(ejbNameAttribute);
        }
        if (!this.already.containsKey(refName = this.name(new Properties()))) {
            this.already.put(refName, this.currentTag);
            if (this.refedEJBClass != null) {
                EnvEjbRefTagsHandler.pushCurrentClass((XClass)this.refedEJBClass);
            }
            this.generate(template);
            if (this.refedEJBClass != null) {
                EnvEjbRefTagsHandler.popCurrentClass();
            }
        } else {
            String prevJndiName;
            XTag previousTag = (XTag)this.already.get(refName);
            String prevEjbName = previousTag.getAttributeValue("ejb-name");
            if (prevEjbName == null) {
                prevEjbName = "";
            }
            if ((prevJndiName = previousTag.getAttributeValue("jndi-name")) == null) {
                prevJndiName = "";
            }
            if (!prevEjbName.equals(this.currentTag.getAttributeValue("ejb-name")) && !prevJndiName.equals(this.currentTag.getAttributeValue("jndi-name"))) {
                log.error((Object)"Duplicate @ejb.ejb-ref found with different parameters!");
                log.error((Object)("Previous tag: @ejb.ejb-ref ref-name=\"" + previousTag.getAttributeValue("ref-name") + "\" ejb-name=\"" + previousTag.getAttributeValue("ejb-name") + "\" view-type=\"" + previousTag.getAttributeValue("view-type") + "\""));
                log.error((Object)("Current tag: @ejb.ejb-ref ref-name=\"" + this.currentTag.getAttributeValue("ref-name") + "\" ejb-name=\"" + this.currentTag.getAttributeValue("ejb-name") + "\" view-type=\"" + this.currentTag.getAttributeValue("view-type") + "\""));
                throw new XDocletException("Duplicate @ejb.ejb-ref with different parameters");
            }
            log.warn((Object)("Duplicated @ejb.ejb-ref found, ref-name=\"" + refName + "\""));
        }
        this.referringClassId = null;
    }

    protected void storeReferringClassId() throws XDocletException {
        this.referringClassId = EjbTagsHandler.getEjbIdFor(EnvEjbRefTagsHandler.getCurrentClass());
    }

    protected XClass findEjb(String ejbName) throws XDocletException {
        Collection classes = EnvEjbRefTagsHandler.getXJavaDoc().getSourceClasses();
        for (XClass clazz : classes) {
            if (!EjbTagsHandler.isEjb(clazz) || !ejbName.equals(EjbTagsHandler.getEjbNameFor(clazz))) continue;
            return clazz;
        }
        throw new XDocletException(Translator.getString(XDocletModulesEjbMessages.class, (String)"NOT_DEFINED", (String[])new String[]{ejbName}));
    }
}

