/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.callback;

import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.CallbackErrorHandler;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;

public class DefaultCallbackErrorHandler
implements CallbackErrorHandler {
    private static final Logger log = Logger.getLogger(DefaultCallbackErrorHandler.class);
    public static final String CALLBACK_ERRORS_ALLOWED = "callbackErrorsAllowed";
    private static final int DEFAULT_NUMBER_OF_ERRORS_ALLOWED = 5;
    private ServerInvoker serverInvoker;
    private ServerInvokerCallbackHandler callbackHandler;
    private int numOfErrorsAllowed = 5;
    private int currentNumberOfErrors;
    private String handlerSubsystem;

    public void setConfig(Map errorHandlerConfig) {
        if (errorHandlerConfig == null) {
            log.warn((Object)(this + " got null configuration"));
            return;
        }
        this.handlerSubsystem = (String)errorHandlerConfig.get("handlerSubsystem");
        Object value = errorHandlerConfig.get(CALLBACK_ERRORS_ALLOWED);
        if (value != null) {
            if (value instanceof String) {
                String stringValue = (String)value;
                try {
                    this.numOfErrorsAllowed = Integer.parseInt(stringValue);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)(this + " could not convert configuration value for " + CALLBACK_ERRORS_ALLOWED + " (" + stringValue + ") into a numeric value."));
                }
            } else if (value instanceof Integer) {
                this.numOfErrorsAllowed = (Integer)value;
            } else {
                log.warn((Object)(this + " could not convert configuration value for " + CALLBACK_ERRORS_ALLOWED + " (" + value + ") into a numeric value. " + "Type of value should be either String or Integer."));
            }
        }
    }

    public synchronized void handleError(Throwable ex) throws Throwable {
        ++this.currentNumberOfErrors;
        log.debug((Object)(this + " handling " + ex + ". Number of errors so far " + this.currentNumberOfErrors));
        if (this.currentNumberOfErrors < this.numOfErrorsAllowed) {
            log.debug((Object)(this + " ignoring the callback error"));
            throw ex;
        }
        log.debug((Object)(this + " reached maximum number of callback errors allowed (" + this.numOfErrorsAllowed + "). Will clean up callback hander now."));
        if (this.serverInvoker != null) {
            this.serverInvoker.removeCallbackListener(this.handlerSubsystem, this.callbackHandler);
            this.callbackHandler.destroy();
        }
        throw ex;
    }

    public void setServerInvoker(ServerInvoker serverInvoker) {
        log.debug((Object)(this + " setting server invoker to " + serverInvoker));
        this.serverInvoker = serverInvoker;
    }

    public void setCallbackHandler(ServerInvokerCallbackHandler callbackHandler) {
        log.debug((Object)(this + " setting callback handler to " + callbackHandler));
        this.callbackHandler = callbackHandler;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DefaultCallbackErrorHandler[");
        if (this.serverInvoker == null) {
            sb.append("UNITIALIZED");
        } else {
            sb.append(this.serverInvoker);
        }
        sb.append(']');
        return sb.toString();
    }
}

