/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.serialization;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.serialization.ClassLoaderUtility;
import org.jboss.remoting.serialization.SerializationManager;
import org.jboss.remoting.serialization.SerializationStreamFactoryMBean;
import org.jboss.remoting.serialization.impl.java.JavaEncryptionSerializationManager;
import org.jboss.remoting.serialization.impl.java.JavaSerializationManager;
import org.jboss.remoting.serialization.impl.jboss.JBossEncryptionSerializationManager;
import org.jboss.remoting.util.SecurityUtility;

public class SerializationStreamFactory
implements SerializationStreamFactoryMBean {
    protected static final Logger log = Logger.getLogger(SerializationStreamFactory.class);
    private static Map managers = new HashMap();
    public static final String DEFAULT = "default";
    public static final String JAVA = "java";
    public static final String JBOSS = "jboss";
    public static final String JAVA_ENCRYPT = "javaencrypt";
    public static final String JBOSS_ENCRYPT = "jbossencrypt";

    public static void setManagerClassName(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        SerializationStreamFactory.setManagerClassName(DEFAULT, className);
    }

    public static void setManagerClassName(String key, String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        SerializationStreamFactory.loadObjectManagerClass(key, className);
    }

    public String getManager() {
        return this.getManager(DEFAULT);
    }

    public String getManager(String key) {
        SerializationManager manager = (SerializationManager)managers.get(key);
        if (manager == null) {
            return null;
        }
        return manager.getClass().getName();
    }

    public void setManager(String manager) throws Exception {
        this.setManager(DEFAULT, manager);
    }

    public void setManager(String key, String manager) throws Exception {
        SerializationStreamFactory.setManagerClassName(key, manager);
    }

    private static void loadObjectManagerClass(String key, String managerClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class managerClass = ClassLoaderUtility.loadClass(SerializationStreamFactory.class, managerClassName);
        SerializationManager manager = (SerializationManager)managerClass.newInstance();
        if (managers.get(key) != null) {
            managers.remove(key);
        }
        managers.put(key, manager);
    }

    public static SerializationManager getManagerInstance(String key) throws IOException {
        SerializationManager manager;
        if (key == null) {
            key = JAVA;
        }
        if ((manager = (SerializationManager)managers.get(key)) == null) {
            throw new IOException("Unknown serialization type: " + key);
        }
        return manager;
    }

    public static SerializationManager getManagerInstance() throws IOException {
        return SerializationStreamFactory.getManagerInstance(DEFAULT);
    }

    private static String getSystemProperty(final String name, final String defaultValue) {
        if (SecurityUtility.skipAccessControl()) {
            return System.getProperty(name, defaultValue);
        }
        String value = null;
        try {
            value = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return System.getProperty(name, defaultValue);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
        return value;
    }

    static {
        try {
            String defaultValue = JavaSerializationManager.class.getName();
            String managerClassName = SerializationStreamFactory.getSystemProperty("SERIALIZATION", defaultValue);
            SerializationStreamFactory.setManagerClassName(DEFAULT, managerClassName);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            SerializationStreamFactory.setManagerClassName(JAVA, JavaSerializationManager.class.getName());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            SerializationStreamFactory.setManagerClassName(JBOSS, "org.jboss.remoting.serialization.impl.jboss.JBossSerializationManager");
        }
        catch (Throwable e) {
            log.debug((Object)"Could not load JBoss Serialization.  Use Java Serialization default.");
            log.trace((Object)e);
        }
        try {
            SerializationStreamFactory.setManagerClassName(JAVA_ENCRYPT, JavaEncryptionSerializationManager.class.getName());
        }
        catch (Throwable e) {
            log.debug((Object)"Could not load Java Encrypted Serialization.  Use Java Serialization default.");
            log.trace((Object)e);
        }
        try {
            SerializationStreamFactory.setManagerClassName(JBOSS_ENCRYPT, JBossEncryptionSerializationManager.class.getName());
        }
        catch (Throwable e) {
            log.debug((Object)"Could not load JBoss Encrypted Serialization.  Use Java Serialization default.");
            log.trace((Object)e);
        }
    }
}

