/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.serialization.impl.jboss;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.logging.Logger;
import org.jboss.remoting.loading.ObjectInputStreamWithClassLoader;
import org.jboss.remoting.serialization.IMarshalledValue;
import org.jboss.remoting.serialization.SerializationManager;
import org.jboss.remoting.serialization.SerializationStreamFactory;
import org.jboss.remoting.serialization.impl.jboss.MarshalledValue;
import org.jboss.remoting.serialization.impl.jboss.SmartCloningMarshalledValue;
import org.jboss.remoting.util.SecurityUtility;
import org.jboss.serial.io.JBossObjectInputStream;
import org.jboss.serial.io.JBossObjectOutputStream;
import org.jboss.serial.util.StringUtilBuffer;

public class JBossSerializationManager
extends SerializationManager {
    protected static final Logger log = Logger.getLogger(JBossSerializationManager.class);
    private static boolean trace = log.isTraceEnabled();

    public ObjectInputStream createInput(final InputStream input, final ClassLoader loader) throws IOException {
        if (trace) {
            log.trace((Object)(this + " creating JBossObjectInputStream"));
        }
        if (SecurityUtility.skipAccessControl()) {
            return new JBossObjectInputStream(input, loader, new StringUtilBuffer(10024, 10024));
        }
        try {
            return (ObjectInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new JBossObjectInputStream(input, loader, new StringUtilBuffer(10024, 10024));
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public ObjectOutputStream createOutput(final OutputStream output) throws IOException {
        if (trace) {
            log.trace((Object)(this + " creating JBossObjectOutputStream"));
        }
        if (SecurityUtility.skipAccessControl()) {
            return new JBossObjectOutputStream(output, new StringUtilBuffer(10024, 10024));
        }
        try {
            return (ObjectOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new JBossObjectOutputStream(output, new StringUtilBuffer(10024, 10024));
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public IMarshalledValue createdMarshalledValue(Object source) throws IOException {
        if (source instanceof IMarshalledValue) {
            return (IMarshalledValue)source;
        }
        return new MarshalledValue(source);
    }

    public IMarshalledValue createMarshalledValueForClone(Object original) throws IOException {
        return new SmartCloningMarshalledValue(original);
    }

    public void sendObject(final ObjectOutputStream oos, final Object dataObject, int version) throws IOException {
        if (SecurityUtility.skipAccessControl()) {
            oos.writeObject(dataObject);
            oos.flush();
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    oos.writeObject(dataObject);
                    oos.flush();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public Object receiveObject(InputStream inputStream, ClassLoader customClassLoader, int version) throws IOException, ClassNotFoundException {
        ObjectInputStream objInputStream = null;
        Object obj = null;
        if (inputStream instanceof ObjectInputStreamWithClassLoader) {
            ((ObjectInputStreamWithClassLoader)inputStream).setClassLoader(customClassLoader);
            objInputStream = (ObjectInputStream)inputStream;
        } else if (inputStream instanceof JBossObjectInputStream) {
            ((JBossObjectInputStream)inputStream).setClassLoader(customClassLoader);
            objInputStream = (ObjectInputStream)inputStream;
        } else {
            objInputStream = inputStream instanceof ObjectInputStream ? (ObjectInputStream)inputStream : (customClassLoader != null ? SerializationStreamFactory.getManagerInstance("jboss").createInput(inputStream, customClassLoader) : SerializationStreamFactory.getManagerInstance("jboss").createRegularInput(inputStream));
        }
        if (SecurityUtility.skipAccessControl()) {
            return objInputStream.readObject();
        }
        try {
            final ObjectInputStream ois = objInputStream;
            obj = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ois.readObject();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
        return obj;
    }

    public String toString() {
        return "JBossSerializationManager[" + Integer.toHexString(this.hashCode()) + "]";
    }
}

