/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.InvocationContext;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.interceptor.InterceptorInfo;
import org.jboss.logging.Logger;

public abstract class LifecycleInvocationContextImpl
implements InvocationContext {
    private static final Logger log = Logger.getLogger(LifecycleInvocationContextImpl.class);
    private int currentInterceptor;
    private int currentMethod;
    BeanContext beanContext;
    InterceptorInfo[] interceptorInfos;
    Object[] instances;
    private Method[] beanMethods;
    private HashMap metadata;
    private Object[] parameters;

    protected LifecycleInvocationContextImpl() {
    }

    public static InvocationContext getLifecycleInvocationContext(Class type, BeanContext beanContext, InterceptorInfo[] interceptorInfos, Method[] beanMethods) {
        LifecycleInvocationContextImpl ic = null;
        if (type == PostConstruct.class) {
            ic = new PostConstructICtxImpl();
        } else if (type == PostActivate.class) {
            ic = new PostActivateICtxImpl();
        } else if (type == PrePassivate.class) {
            ic = new PrePassivateICtxImpl();
        } else if (type == PreDestroy.class) {
            ic = new PreDestroyICtxImpl();
        } else {
            throw new RuntimeException("Unsupported lifecycle event: " + type);
        }
        ic.instances = beanContext.getInterceptorInstances(interceptorInfos);
        if (interceptorInfos.length != ic.instances.length) {
            throw new RuntimeException("interceptorInfos and instances have different length");
        }
        ic.beanContext = beanContext;
        ic.beanMethods = beanMethods;
        ic.interceptorInfos = interceptorInfos;
        return ic;
    }

    public Object getTarget() {
        return this.beanContext.getInstance();
    }

    public Method getMethod() {
        return null;
    }

    public Object[] getParameters() {
        if (this.parameters == null) {
            this.parameters = new Object[0];
        }
        return this.parameters;
    }

    public void setParameters(Object[] params) {
        this.parameters = params;
    }

    public Map getContextData() {
        if (this.metadata == null) {
            this.metadata = new HashMap();
        }
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object proceed() throws Exception {
        if (this.currentInterceptor < this.interceptorInfos.length) {
            int oldMethod;
            int oldInterceptor;
            block17: {
                oldInterceptor = this.currentInterceptor;
                oldMethod = this.currentMethod;
                try {
                    Object object;
                    int curr = this.currentInterceptor++;
                    int currMethod = this.currentMethod++;
                    InterceptorInfo info = this.interceptorInfos[curr];
                    if (currMethod == this.getLifecycleMethods(info).length) {
                        curr = this.currentInterceptor;
                        this.currentMethod = 0;
                        currMethod = this.currentMethod++;
                        InterceptorInfo interceptorInfo = info = curr < this.interceptorInfos.length ? this.interceptorInfos[curr] : null;
                    }
                    if (info == null) break block17;
                    try {
                        Method[] methods = this.getLifecycleMethods(info);
                        object = methods[currMethod].invoke(this.instances[curr], this);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getTargetException() instanceof Exception) {
                            throw (Exception)e.getCause();
                        }
                        throw new RuntimeException(e.getCause());
                    }
                    Object var9_12 = null;
                    this.currentInterceptor = oldInterceptor;
                    this.currentMethod = oldMethod;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    this.currentInterceptor = oldInterceptor;
                    this.currentMethod = oldMethod;
                    throw throwable;
                }
            }
            Object var9_13 = null;
            this.currentInterceptor = oldInterceptor;
            this.currentMethod = oldMethod;
        }
        if (this.beanMethods == null) {
            return null;
        }
        try {
            try {
                Method[] arr$ = this.beanMethods;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) {
                        return null;
                    }
                    Method beanMethod = arr$[i$];
                    if (beanMethod.getParameterAnnotations().length == this.getParameters().length) {
                        beanMethod.invoke(this.getTarget(), this.getParameters());
                    } else {
                        log.error((Object)("Skip attempt of invalid lifecycle method invocation: " + beanMethod));
                    }
                    ++i$;
                }
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            throw throwable;
        }
    }

    abstract Method[] getLifecycleMethods(InterceptorInfo var1);

    public static class PreDestroyICtxImpl
    extends LifecycleInvocationContextImpl {
        Method[] getLifecycleMethods(InterceptorInfo info) {
            return info.getPreDestroys();
        }
    }

    public static class PrePassivateICtxImpl
    extends LifecycleInvocationContextImpl {
        Method[] getLifecycleMethods(InterceptorInfo info) {
            return info.getPrePassivates();
        }
    }

    public static class PostActivateICtxImpl
    extends LifecycleInvocationContextImpl {
        Method[] getLifecycleMethods(InterceptorInfo info) {
            return info.getPostActivates();
        }
    }

    public static class PostConstructICtxImpl
    extends LifecycleInvocationContextImpl {
        Method[] getLifecycleMethods(InterceptorInfo info) {
            return info.getPostConstructs();
        }
    }
}

