/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import javax.ejb.EJBAccessException;
import javax.security.auth.Subject;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.ejb3.security.SecurityActions;
import org.jboss.ejb3.security.SecurityHelper;
import org.jboss.logging.Logger;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityUtil;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.plugins.SimpleIdentity;
import org.jboss.security.javaee.EJBAuthenticationHelper;
import org.jboss.security.javaee.SecurityHelperFactory;

public class Ejb3AuthenticationInterceptorv2
implements Interceptor {
    protected Logger log = Logger.getLogger(this.getClass());
    private EJBContainer container;

    public Ejb3AuthenticationInterceptorv2(Container container) {
        this.container = (EJBContainer)container;
    }

    public String getName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        SecurityHelper shelper = new SecurityHelper();
        MethodInvocation mi = (MethodInvocation)invocation;
        Method method = mi.getMethod();
        if (shelper.isEJBTimeOutCallback(method) || shelper.containsTimeoutAnnotation(this.container, method) || shelper.isMDB(this.container)) {
            return invocation.invokeNext();
        }
        SecurityContext prevSC = SecurityActions.getSecurityContext();
        try {
            boolean domainExists;
            SecurityContext invSC = (SecurityContext)invocation.getMetaData((Object)"security", (Object)"context");
            SecurityDomain domain = this.container.getAnnotation(SecurityDomain.class);
            boolean bl = domainExists = domain != null && domain.value() != null && domain.value().length() > 0;
            if (domainExists) {
                boolean trustedCaller;
                String domainValue = this.canonicalizeSecurityDomain(domain.value());
                final SecurityContext sc = SecurityActions.createSecurityContext(domainValue);
                if (shelper.isLocalCall(mi)) {
                    if (prevSC == null) {
                        throw new IllegalStateException("Local Call: Security Context is null");
                    }
                    this.populateSecurityContext(sc, prevSC);
                } else {
                    if (invSC == null) {
                        throw new IllegalStateException("Remote Call: Invocation Security Context is null");
                    }
                    this.populateSecurityContext(sc, invSC);
                }
                SecurityActions.setSecurityContext(sc);
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        sc.setSecurityManagement(Ejb3AuthenticationInterceptorv2.this.getSecurityManagement());
                        return null;
                    }
                });
                EJBAuthenticationHelper helper = null;
                try {
                    helper = SecurityHelperFactory.getEJBAuthenticationHelper((SecurityContext)sc);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                boolean bl2 = trustedCaller = this.hasIncomingRunAsIdentity(sc) || helper.isTrusted();
                if (!trustedCaller) {
                    Subject subject = new Subject();
                    Principal userPrincipal = sc.getUtil().getUserPrincipal();
                    String unauthenticatedPrincipal = domain.unauthenticatedPrincipal();
                    if (userPrincipal == null && unauthenticatedPrincipal != null && unauthenticatedPrincipal.length() > 0) {
                        SimpleIdentity unauthenticatedIdentity = new SimpleIdentity(unauthenticatedPrincipal);
                        sc.getSubjectInfo().addIdentity((Identity)unauthenticatedIdentity);
                        subject.getPrincipals().add(unauthenticatedIdentity.asPrincipal());
                    } else if (!helper.isValid(subject, method.getName())) {
                        throw new EJBAccessException("Invalid User");
                    }
                    helper.pushSubjectContext(subject);
                }
            } else if (invSC != null) {
                SecurityActions.setSecurityContext(invSC);
            }
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            SecurityActions.setSecurityContext(prevSC);
        }
    }

    private String canonicalizeSecurityDomain(String securityDomain) {
        return SecurityUtil.unprefixSecurityDomain((String)securityDomain);
    }

    private void populateSecurityContext(SecurityContext to, SecurityContext from) {
        SecurityActions.setSubjectInfo(to, from.getSubjectInfo());
        SecurityActions.setIncomingRunAs(to, from.getOutgoingRunAs());
    }

    private ISecurityManagement getSecurityManagement() throws Exception {
        Class<?> clazz = SecurityActions.loadClass("org.jboss.security.integration.JNDIBasedSecurityManagement");
        return (ISecurityManagement)clazz.newInstance();
    }

    private boolean hasIncomingRunAsIdentity(SecurityContext sc) {
        RunAs incomingRunAs = sc.getIncomingRunAs();
        return incomingRunAs != null && incomingRunAs instanceof RunAsIdentity;
    }
}

