/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.connectionmanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.aop.AspectManager;
import org.jboss.jms.delegate.ConnectionEndpoint;
import org.jboss.jms.server.ConnectionManager;
import org.jboss.jms.server.endpoint.ServerConnectionEndpoint;
import org.jboss.jms.server.endpoint.ServerConnectionFactoryEndpoint;
import org.jboss.jms.server.endpoint.advised.ConnectionAdvised;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.ClusterNotification;
import org.jboss.messaging.core.contract.ClusterNotificationListener;
import org.jboss.messaging.core.contract.Replicator;
import org.jboss.messaging.util.ConcurrentHashSet;
import org.jboss.messaging.util.Util;
import org.jboss.remoting.Client;
import org.jboss.remoting.ClientDisconnectedException;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;

public class SimpleConnectionManager
implements ConnectionManager,
ConnectionListener,
ClusterNotificationListener {
    private static final Logger log = Logger.getLogger(SimpleConnectionManager.class);
    private static boolean trace = log.isTraceEnabled();
    private Map<String, Map<String, ConnectionEndpoint>> jmsClients;
    private Map<String, Map<String, InvokerCallbackHandler>> cfHandlers;
    private Map<String, String> remotingSessions;
    private Set<ConnectionEndpoint> activeConnectionEndpoints;
    private Replicator replicator;
    private Set<ServerConnectionFactoryEndpoint> connectionFactories = new ConcurrentHashSet<ServerConnectionFactoryEndpoint>();

    public SimpleConnectionManager() {
        this.jmsClients = new HashMap<String, Map<String, ConnectionEndpoint>>();
        this.remotingSessions = new HashMap<String, String>();
        this.cfHandlers = new HashMap<String, Map<String, InvokerCallbackHandler>>();
        this.activeConnectionEndpoints = new HashSet<ConnectionEndpoint>();
    }

    public synchronized void registerConnection(String jmsClientVMID, String remotingClientSessionID, ConnectionEndpoint endpoint) {
        Map<String, ConnectionEndpoint> endpoints = this.jmsClients.get(jmsClientVMID);
        if (endpoints == null) {
            endpoints = new HashMap<String, ConnectionEndpoint>();
            this.jmsClients.put(jmsClientVMID, endpoints);
        }
        endpoints.put(remotingClientSessionID, endpoint);
        this.remotingSessions.put(remotingClientSessionID, jmsClientVMID);
        this.activeConnectionEndpoints.add(endpoint);
        log.debug((Object)("registered connection " + endpoint + " as " + Util.guidToString(remotingClientSessionID)));
    }

    public synchronized void registerConnectionFactoryCallback(String JVMID, String remotingSessionID, InvokerCallbackHandler handler) {
        Map<String, InvokerCallbackHandler> handlers = this.cfHandlers.get(JVMID);
        if (handlers == null) {
            handlers = new HashMap<String, InvokerCallbackHandler>();
            this.cfHandlers.put(JVMID, handlers);
        }
        handlers.put(remotingSessionID, handler);
        this.remotingSessions.put(remotingSessionID, JVMID);
        log.debug((Object)("registered cf callback handler " + handler + " as " + Util.guidToString(remotingSessionID)));
    }

    public synchronized ConnectionEndpoint unregisterConnection(String jmsClientVMId, String remotingClientSessionID) {
        Map<String, ConnectionEndpoint> endpoints = this.jmsClients.get(jmsClientVMId);
        if (endpoints != null) {
            ConnectionEndpoint e = endpoints.remove(remotingClientSessionID);
            if (e != null) {
                this.activeConnectionEndpoints.remove(e);
            }
            log.debug((Object)("unregistered connection " + e + " with remoting session ID " + Util.guidToString(remotingClientSessionID)));
            if (endpoints.isEmpty()) {
                this.jmsClients.remove(jmsClientVMId);
            }
            this.remotingSessions.remove(remotingClientSessionID);
            return e;
        }
        return null;
    }

    public synchronized void unregisterConnectionFactoryCallback(String JVMID, String remotingSessionID) {
        Map<String, InvokerCallbackHandler> handlers = this.cfHandlers.get(JVMID);
        if (handlers != null) {
            handlers.remove(remotingSessionID);
            if (handlers.isEmpty()) {
                this.cfHandlers.remove(JVMID);
            }
            this.remotingSessions.remove(remotingSessionID);
        }
    }

    public synchronized List getActiveConnections() {
        ArrayList<ConnectionEndpoint> list = new ArrayList<ConnectionEndpoint>();
        list.addAll(this.activeConnectionEndpoints);
        return list;
    }

    public synchronized void handleClientFailure(String remotingSessionID) {
        this.cleanupForSessionID(remotingSessionID);
    }

    public void registerConnectionFactory(ServerConnectionFactoryEndpoint cf) {
        this.connectionFactories.add(cf);
    }

    public void unregisterConnectionFactory(ServerConnectionFactoryEndpoint cf) {
        this.connectionFactories.remove(cf);
    }

    public void handleConnectionException(Throwable t, Client client) {
        String remotingSessionID;
        if (t instanceof ClientDisconnectedException) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Connection is closed normally: " + client));
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Connection is closed on failure event: " + client));
        }
        if ((remotingSessionID = client.getSessionId()) != null) {
            this.handleClientFailure(remotingSessionID);
        }
    }

    public void notify(ClusterNotification notification) {
        if (notification.type == 5) {
            log.trace((Object)("SimpleConnectionManager was notified about node leaving from node " + notification.nodeID));
            try {
                Map ids = this.replicator.get((Serializable)((Object)"JVMID"));
                if (ids == null) {
                    log.trace((Object)"Cannot find jvmid map");
                    throw new IllegalStateException("Cannot find jvmid map");
                }
                int failedNodeID = notification.nodeID;
                String clientVMID = (String)ids.get(new Integer(failedNodeID));
                if (clientVMID == null) {
                    log.error((Object)("Cannot find ClientVMID for failed node " + failedNodeID));
                    throw new IllegalStateException("Cannot find clientVMID for failed node " + failedNodeID);
                }
                log.trace((Object)("Closing consumers for clientVMID=" + clientVMID));
                if (clientVMID != null) {
                    this.cleanupForVMID(clientVMID);
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to process failover start", (Throwable)e);
            }
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public synchronized boolean containsRemotingSession(String remotingClientSessionID) {
        return this.remotingSessions.containsKey(remotingClientSessionID);
    }

    public synchronized Map getClients() {
        return Collections.unmodifiableMap(this.jmsClients);
    }

    public void injectReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    public String toString() {
        return "ConnectionManager[" + Integer.toHexString(this.hashCode()) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanupForVMID(String jmsClientID) {
        Map<String, InvokerCallbackHandler> handlers;
        Map<String, ConnectionEndpoint> endpoints = this.jmsClients.get(jmsClientID);
        if (endpoints != null) {
            ArrayList<ConnectionEndpoint> sces = new ArrayList<ConnectionEndpoint>(endpoints.values());
            for (ConnectionEndpoint sce : sces) {
                log.debug((Object)("clearing up state for connection " + sce));
                if (sce instanceof ServerConnectionEndpoint) {
                    ((ServerConnectionEndpoint)sce).closeCallbackClient();
                }
                AspectManager aspectManager = AspectManager.instance();
                synchronized (aspectManager) {
                    sce = new ConnectionAdvised(sce);
                }
                try {
                    sce.closing(-1L);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    sce.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                log.debug((Object)("cleared up state for connection " + sce));
            }
        }
        if ((handlers = this.cfHandlers.remove(jmsClientID)) != null) {
            HashMap<String, InvokerCallbackHandler> handlersClone = new HashMap<String, InvokerCallbackHandler>(handlers);
            for (Map.Entry entry : handlersClone.entrySet()) {
                try {
                    ((ServerInvokerCallbackHandler)entry.getValue()).getCallbackClient().disconnect();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    ((ServerInvokerCallbackHandler)entry.getValue()).shutdown();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                for (ServerConnectionFactoryEndpoint ep : this.connectionFactories) {
                    ep.removeCallbackhandler((InvokerCallbackHandler)((ServerInvokerCallbackHandler)entry.getValue()));
                }
                this.unregisterConnectionFactoryCallback(jmsClientID, (String)entry.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupForSessionID(String jmsSessionID) {
        Map<String, InvokerCallbackHandler> handlers;
        Map<String, ConnectionEndpoint> endpoints;
        String jmsClientID = this.remotingSessions.get(jmsSessionID);
        log.trace((Object)("A problem has been detected with the connection to remote client " + jmsSessionID + ", jmsClientID=" + jmsClientID + ". It is possible the client has exited without closing " + "its connection(s) or the network has failed. All associated connection resources will be cleaned up."));
        if (jmsClientID != null && (endpoints = this.jmsClients.get(jmsClientID)) != null) {
            ConnectionEndpoint conn = null;
            for (Map.Entry<String, ConnectionEndpoint> entry : endpoints.entrySet()) {
                if (!entry.getKey().equals(jmsSessionID)) continue;
                conn = entry.getValue();
                break;
            }
            if (conn != null) {
                if (conn instanceof ServerConnectionEndpoint) {
                    ((ServerConnectionEndpoint)conn).closeCallbackClient();
                }
                AspectManager i$ = AspectManager.instance();
                synchronized (i$) {
                    conn = new ConnectionAdvised(conn);
                }
                try {
                    conn.closing(-1L);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                return;
            }
        }
        if ((handlers = this.cfHandlers.get(jmsClientID)) != null) {
            boolean found = false;
            for (Map.Entry<String, ConnectionEndpoint> entry : handlers.entrySet()) {
                if (!entry.getKey().equals(jmsSessionID)) continue;
                try {
                    ((ServerInvokerCallbackHandler)entry.getValue()).getCallbackClient().disconnect();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    ((ServerInvokerCallbackHandler)entry.getValue()).shutdown();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                for (ServerConnectionFactoryEndpoint ep : this.connectionFactories) {
                    ep.removeCallbackhandler((InvokerCallbackHandler)entry.getValue());
                }
                found = true;
                break;
            }
            if (found) {
                this.unregisterConnectionFactoryCallback(jmsClientID, jmsSessionID);
            }
        }
    }
}

