/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.dtd;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAny;
import com.wutka.dtd.DTDAttlist;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDCardinal;
import com.wutka.dtd.DTDChoice;
import com.wutka.dtd.DTDComment;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDDecl;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDEntity;
import com.wutka.dtd.DTDEnumeration;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDNotation;
import com.wutka.dtd.DTDNotationList;
import com.wutka.dtd.DTDPCData;
import com.wutka.dtd.DTDParseException;
import com.wutka.dtd.DTDProcessingInstruction;
import com.wutka.dtd.DTDPublic;
import com.wutka.dtd.DTDSequence;
import com.wutka.dtd.DTDSystem;
import com.wutka.dtd.EntityExpansion;
import com.wutka.dtd.Scanner;
import com.wutka.dtd.Token;
import com.wutka.dtd.TokenType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class DTDParser
implements EntityExpansion {
    protected Scanner scanner;
    protected DTD dtd;
    protected Object defaultLocation;

    public DTDParser(Reader reader) {
        this.scanner = new Scanner(reader, false, this);
        this.dtd = new DTD();
    }

    public DTDParser(Reader reader, boolean bl) {
        this.scanner = new Scanner(reader, bl, this);
        this.dtd = new DTD();
    }

    public DTDParser(File file) throws IOException {
        this.defaultLocation = file.getParentFile();
        this.scanner = new Scanner(new BufferedReader(new FileReader(file)), false, this);
        this.dtd = new DTD();
    }

    public DTDParser(File file, boolean bl) throws IOException {
        this.defaultLocation = file.getParentFile();
        this.scanner = new Scanner(new BufferedReader(new FileReader(file)), bl, this);
        this.dtd = new DTD();
    }

    public DTDParser(URL uRL) throws IOException {
        String string = uRL.getFile();
        this.defaultLocation = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string.substring(0, string.lastIndexOf(47) + 1));
        this.scanner = new Scanner(new BufferedReader(new InputStreamReader(uRL.openStream())), false, this);
        this.dtd = new DTD();
    }

    public DTDParser(URL uRL, boolean bl) throws IOException {
        String string = uRL.getFile();
        this.defaultLocation = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string.substring(0, string.lastIndexOf(47) + 1));
        this.scanner = new Scanner(new BufferedReader(new InputStreamReader(uRL.openStream())), bl, this);
        this.dtd = new DTD();
    }

    public DTD parse() throws IOException {
        return this.parse(false);
    }

    public DTD parse(boolean bl) throws IOException {
        while (true) {
            Token token = this.scanner.peek();
            if (token.type == Scanner.EOF) break;
            this.parseTopLevelElement();
        }
        if (bl) {
            DTDElement dTDElement;
            Hashtable<String, DTDElement> hashtable = new Hashtable<String, DTDElement>();
            Enumeration enumeration = this.dtd.elements.elements();
            while (enumeration.hasMoreElements()) {
                dTDElement = (DTDElement)enumeration.nextElement();
                hashtable.put(dTDElement.name, dTDElement);
            }
            enumeration = this.dtd.elements.elements();
            while (enumeration.hasMoreElements()) {
                dTDElement = (DTDElement)enumeration.nextElement();
                if (!(dTDElement.content instanceof DTDContainer)) continue;
                Enumeration enumeration2 = ((DTDContainer)dTDElement.content).getItemsVec().elements();
                while (enumeration2.hasMoreElements()) {
                    this.removeElements(hashtable, this.dtd, (DTDItem)enumeration2.nextElement());
                }
            }
            if (hashtable.size() == 1) {
                enumeration = hashtable.elements();
                this.dtd.rootElement = (DTDElement)enumeration.nextElement();
            } else {
                this.dtd.rootElement = null;
            }
        } else {
            this.dtd.rootElement = null;
        }
        return this.dtd;
    }

    protected void removeElements(Hashtable hashtable, DTD dTD, DTDItem dTDItem) {
        if (dTDItem instanceof DTDName) {
            hashtable.remove(((DTDName)dTDItem).value);
        } else if (dTDItem instanceof DTDContainer) {
            Enumeration enumeration = ((DTDContainer)dTDItem).getItemsVec().elements();
            while (enumeration.hasMoreElements()) {
                this.removeElements(hashtable, dTD, (DTDItem)enumeration.nextElement());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseTopLevelElement() throws IOException {
        Token token = this.scanner.get();
        if (token.type == Scanner.LTQUES) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            while (true) {
                object = this.scanner.getUntil('?');
                stringBuffer.append((String)object);
                token = this.scanner.peek();
                if (token.type == Scanner.GT) break;
                stringBuffer.append('?');
            }
            this.scanner.get();
            object = new DTDProcessingInstruction(stringBuffer.toString());
            this.dtd.items.addElement(object);
            return;
        }
        if (token.type == Scanner.CONDITIONAL) {
            token = this.expect(Scanner.IDENTIFIER);
            if (token.value.equals("IGNORE")) {
                this.scanner.skipConditional();
                return;
            } else {
                if (!token.value.equals("INCLUDE")) throw new DTDParseException(this.scanner.getUriId(), "Invalid token in conditional: " + token.value, this.scanner.getLineNumber(), this.scanner.getColumn());
                this.scanner.skipUntil('[');
            }
            return;
        } else {
            if (token.type == Scanner.ENDCONDITIONAL) return;
            if (token.type == Scanner.COMMENT) {
                this.dtd.items.addElement(new DTDComment(token.value));
                return;
            } else {
                if (token.type != Scanner.LTBANG) throw new DTDParseException(this.scanner.getUriId(), "Unexpected token: " + token.type.name + "(" + token.value + ")", this.scanner.getLineNumber(), this.scanner.getColumn());
                token = this.expect(Scanner.IDENTIFIER);
                if (token.value.equals("ELEMENT")) {
                    this.parseElement();
                    return;
                } else if (token.value.equals("ATTLIST")) {
                    this.parseAttlist();
                    return;
                } else if (token.value.equals("ENTITY")) {
                    this.parseEntity();
                    return;
                } else if (token.value.equals("NOTATION")) {
                    this.parseNotation();
                    return;
                } else {
                    this.skipUntil(Scanner.GT);
                }
            }
        }
    }

    protected void skipUntil(TokenType tokenType) throws IOException {
        Token token = this.scanner.get();
        while (token.type != tokenType) {
            token = this.scanner.get();
        }
    }

    protected Token expect(TokenType tokenType) throws IOException {
        Token token = this.scanner.get();
        if (token.type != tokenType) {
            if (token.value == null) {
                throw new DTDParseException(this.scanner.getUriId(), "Expected " + tokenType.name + " instead of " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            throw new DTDParseException(this.scanner.getUriId(), "Expected " + tokenType.name + " instead of " + token.type.name + "(" + token.value + ")", this.scanner.getLineNumber(), this.scanner.getColumn());
        }
        return token;
    }

    protected void parseElement() throws IOException {
        Token token = this.expect(Scanner.IDENTIFIER);
        DTDElement dTDElement = (DTDElement)this.dtd.elements.get(token.value);
        if (dTDElement == null) {
            dTDElement = new DTDElement(token.value);
            this.dtd.elements.put(dTDElement.name, dTDElement);
        } else if (dTDElement.content != null) {
            throw new DTDParseException(this.scanner.getUriId(), "Found second definition of element: " + token.value, this.scanner.getLineNumber(), this.scanner.getColumn());
        }
        this.dtd.items.addElement(dTDElement);
        this.parseContentSpec(this.scanner, dTDElement);
        this.expect(Scanner.GT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseContentSpec(Scanner scanner, DTDElement dTDElement) throws IOException {
        Token token = scanner.get();
        if (token.type == Scanner.IDENTIFIER) {
            if (token.value.equals("EMPTY")) {
                dTDElement.content = new DTDEmpty();
                return;
            } else {
                if (!token.value.equals("ANY")) throw new DTDParseException(scanner.getUriId(), "Invalid token in entity content spec " + token.value, scanner.getLineNumber(), scanner.getColumn());
                dTDElement.content = new DTDAny();
            }
            return;
        } else {
            if (token.type != Scanner.LPAREN) return;
            token = scanner.peek();
            if (token.type == Scanner.IDENTIFIER) {
                if (token.value.equals("#PCDATA")) {
                    this.parseMixed(dTDElement);
                    return;
                } else {
                    this.parseChildren(dTDElement);
                }
                return;
            } else {
                if (token.type != Scanner.LPAREN) return;
                this.parseChildren(dTDElement);
            }
        }
    }

    protected void parseMixed(DTDElement dTDElement) throws IOException {
        Token token;
        boolean bl = true;
        DTDMixed dTDMixed = new DTDMixed();
        dTDMixed.add(new DTDPCData());
        this.scanner.get();
        dTDElement.content = dTDMixed;
        while (true) {
            token = this.scanner.get();
            if (token.type == Scanner.RPAREN) {
                token = this.scanner.peek();
                if (token.type == Scanner.ASTERISK) {
                    this.scanner.get();
                    dTDMixed.cardinal = DTDCardinal.ZEROMANY;
                } else {
                    if (!bl) {
                        throw new DTDParseException(this.scanner.getUriId(), "Invalid token in Mixed content type, '*' required after (#PCDATA|xx ...): " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
                    }
                    dTDMixed.cardinal = DTDCardinal.NONE;
                }
                return;
            }
            if (token.type != Scanner.PIPE) break;
            token = this.scanner.get();
            dTDMixed.add(new DTDName(token.value));
            bl = false;
        }
        throw new DTDParseException(this.scanner.getUriId(), "Invalid token in Mixed content type: " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
    }

    protected void parseChildren(DTDElement dTDElement) throws IOException {
        DTDContainer dTDContainer = this.parseChoiceSequence();
        Token token = this.scanner.peek();
        dTDContainer.cardinal = this.parseCardinality();
        dTDContainer.cardinal = token.type == Scanner.QUES ? DTDCardinal.OPTIONAL : (token.type == Scanner.ASTERISK ? DTDCardinal.ZEROMANY : (token.type == Scanner.PLUS ? DTDCardinal.ONEMANY : DTDCardinal.NONE));
        dTDElement.content = dTDContainer;
    }

    protected DTDContainer parseChoiceSequence() throws IOException {
        Token token;
        DTDItem dTDItem;
        TokenType tokenType = null;
        DTDContainer dTDContainer = null;
        while (true) {
            dTDItem = this.parseCP();
            token = this.scanner.get();
            if (token.type != Scanner.PIPE && token.type != Scanner.COMMA) break;
            if (tokenType != null && tokenType != token.type) {
                throw new DTDParseException(this.scanner.getUriId(), "Can't mix separators in a choice/sequence", this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            tokenType = token.type;
            if (dTDContainer == null) {
                dTDContainer = token.type == Scanner.PIPE ? new DTDChoice() : new DTDSequence();
            }
            dTDContainer.add(dTDItem);
        }
        if (token.type == Scanner.RPAREN) {
            if (dTDContainer == null) {
                dTDContainer = new DTDSequence();
            }
            dTDContainer.add(dTDItem);
            return dTDContainer;
        }
        throw new DTDParseException(this.scanner.getUriId(), "Found invalid token in sequence: " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
    }

    protected DTDItem parseCP() throws IOException {
        Token token = this.scanner.get();
        DTDItem dTDItem = null;
        if (token.type == Scanner.IDENTIFIER) {
            dTDItem = new DTDName(token.value);
        } else if (token.type == Scanner.LPAREN) {
            dTDItem = this.parseChoiceSequence();
        } else {
            throw new DTDParseException(this.scanner.getUriId(), "Found invalid token in sequence: " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
        }
        dTDItem.cardinal = this.parseCardinality();
        return dTDItem;
    }

    protected DTDCardinal parseCardinality() throws IOException {
        Token token = this.scanner.peek();
        if (token.type == Scanner.QUES) {
            this.scanner.get();
            return DTDCardinal.OPTIONAL;
        }
        if (token.type == Scanner.ASTERISK) {
            this.scanner.get();
            return DTDCardinal.ZEROMANY;
        }
        if (token.type == Scanner.PLUS) {
            this.scanner.get();
            return DTDCardinal.ONEMANY;
        }
        return DTDCardinal.NONE;
    }

    protected void parseAttlist() throws IOException {
        Token token = this.expect(Scanner.IDENTIFIER);
        DTDElement dTDElement = (DTDElement)this.dtd.elements.get(token.value);
        DTDAttlist dTDAttlist = new DTDAttlist(token.value);
        this.dtd.items.addElement(dTDAttlist);
        if (dTDElement == null) {
            dTDElement = new DTDElement(token.value);
            this.dtd.elements.put(token.value, dTDElement);
        }
        token = this.scanner.peek();
        while (token.type != Scanner.GT) {
            this.parseAttdef(this.scanner, dTDElement, dTDAttlist);
            token = this.scanner.peek();
        }
        this.expect(Scanner.GT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseAttdef(Scanner scanner, DTDElement dTDElement, DTDAttlist dTDAttlist) throws IOException {
        Token token = this.expect(Scanner.IDENTIFIER);
        DTDAttribute dTDAttribute = new DTDAttribute(token.value);
        dTDAttlist.attributes.addElement(dTDAttribute);
        dTDElement.attributes.put(token.value, dTDAttribute);
        token = scanner.get();
        if (token.type == Scanner.IDENTIFIER) {
            dTDAttribute.type = token.value.equals("NOTATION") ? this.parseNotationList() : token.value;
        } else if (token.type == Scanner.LPAREN) {
            dTDAttribute.type = this.parseEnumeration();
        }
        token = scanner.peek();
        if (token.type == Scanner.IDENTIFIER) {
            scanner.get();
            if (token.value.equals("#FIXED")) {
                dTDAttribute.decl = DTDDecl.FIXED;
                token = scanner.get();
                dTDAttribute.defaultValue = token.value;
                return;
            } else if (token.value.equals("#REQUIRED")) {
                dTDAttribute.decl = DTDDecl.REQUIRED;
                return;
            } else {
                if (!token.value.equals("#IMPLIED")) throw new DTDParseException(scanner.getUriId(), "Invalid token in attribute declaration: " + token.value, scanner.getLineNumber(), scanner.getColumn());
                dTDAttribute.decl = DTDDecl.IMPLIED;
            }
            return;
        } else {
            if (token.type != Scanner.STRING) return;
            scanner.get();
            dTDAttribute.decl = DTDDecl.VALUE;
            dTDAttribute.defaultValue = token.value;
        }
    }

    protected DTDNotationList parseNotationList() throws IOException {
        DTDNotationList dTDNotationList = new DTDNotationList();
        Token token = this.scanner.get();
        if (token.type != Scanner.LPAREN) {
            throw new DTDParseException(this.scanner.getUriId(), "Invalid token in notation: " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
        }
        while (true) {
            token = this.scanner.get();
            if (token.type != Scanner.IDENTIFIER) {
                throw new DTDParseException(this.scanner.getUriId(), "Invalid token in notation: " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            dTDNotationList.add(token.value);
            token = this.scanner.peek();
            if (token.type == Scanner.RPAREN) {
                this.scanner.get();
                return dTDNotationList;
            }
            if (token.type != Scanner.PIPE) {
                throw new DTDParseException(this.scanner.getUriId(), "Invalid token in notation: " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            this.scanner.get();
        }
    }

    protected DTDEnumeration parseEnumeration() throws IOException {
        DTDEnumeration dTDEnumeration = new DTDEnumeration();
        while (true) {
            Token token = this.scanner.get();
            if (token.type != Scanner.IDENTIFIER && token.type != Scanner.NMTOKEN) {
                throw new DTDParseException(this.scanner.getUriId(), "Invalid token in enumeration: " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            dTDEnumeration.add(token.value);
            token = this.scanner.peek();
            if (token.type == Scanner.RPAREN) {
                this.scanner.get();
                return dTDEnumeration;
            }
            if (token.type != Scanner.PIPE) {
                throw new DTDParseException(this.scanner.getUriId(), "Invalid token in enumeration: " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            this.scanner.get();
        }
    }

    protected void parseEntity() throws IOException {
        boolean bl = false;
        Token token = this.scanner.get();
        if (token.type == Scanner.PERCENT) {
            bl = true;
            token = this.expect(Scanner.IDENTIFIER);
        } else if (token.type != Scanner.IDENTIFIER) {
            throw new DTDParseException(this.scanner.getUriId(), "Invalid entity declaration", this.scanner.getLineNumber(), this.scanner.getColumn());
        }
        DTDEntity dTDEntity = (DTDEntity)this.dtd.entities.get(token.value);
        boolean bl2 = false;
        if (dTDEntity == null) {
            dTDEntity = new DTDEntity(token.value, this.defaultLocation);
            this.dtd.entities.put(dTDEntity.name, dTDEntity);
        } else {
            dTDEntity = new DTDEntity(token.value, this.defaultLocation);
            bl2 = true;
        }
        this.dtd.items.addElement(dTDEntity);
        dTDEntity.isParsed = bl;
        this.parseEntityDef(dTDEntity);
        if (dTDEntity.isParsed && dTDEntity.value != null && !bl2) {
            this.scanner.addEntity(dTDEntity.name, dTDEntity.value);
        }
    }

    protected void parseEntityDef(DTDEntity dTDEntity) throws IOException {
        Token token = this.scanner.get();
        if (token.type == Scanner.STRING) {
            if (dTDEntity.value == null) {
                dTDEntity.value = token.value;
            }
        } else if (token.type == Scanner.IDENTIFIER) {
            if (token.value.equals("SYSTEM")) {
                DTDSystem dTDSystem = new DTDSystem();
                token = this.expect(Scanner.STRING);
                dTDSystem.system = token.value;
                dTDEntity.externalID = dTDSystem;
            } else if (token.value.equals("PUBLIC")) {
                DTDPublic dTDPublic = new DTDPublic();
                token = this.expect(Scanner.STRING);
                dTDPublic.pub = token.value;
                token = this.expect(Scanner.STRING);
                dTDPublic.system = token.value;
                dTDEntity.externalID = dTDPublic;
            } else {
                throw new DTDParseException(this.scanner.getUriId(), "Invalid External ID specification", this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            if (!dTDEntity.isParsed) {
                token = this.scanner.peek();
                if (token.type == Scanner.IDENTIFIER) {
                    if (!token.value.equals("NDATA")) {
                        throw new DTDParseException(this.scanner.getUriId(), "Invalid NData declaration", this.scanner.getLineNumber(), this.scanner.getColumn());
                    }
                    token = this.scanner.get();
                    token = this.expect(Scanner.IDENTIFIER);
                    dTDEntity.ndata = token.value;
                }
            }
        } else {
            throw new DTDParseException(this.scanner.getUriId(), "Invalid entity definition", this.scanner.getLineNumber(), this.scanner.getColumn());
        }
        this.expect(Scanner.GT);
    }

    protected void parseNotation() throws IOException {
        DTDNotation dTDNotation = new DTDNotation();
        Token token = this.expect(Scanner.IDENTIFIER);
        dTDNotation.name = token.value;
        this.dtd.notations.put(dTDNotation.name, dTDNotation);
        this.dtd.items.addElement(dTDNotation);
        token = this.expect(Scanner.IDENTIFIER);
        if (token.value.equals("SYSTEM")) {
            DTDSystem dTDSystem = new DTDSystem();
            token = this.expect(Scanner.STRING);
            dTDSystem.system = token.value;
            dTDNotation.externalID = dTDSystem;
        } else if (token.value.equals("PUBLIC")) {
            DTDPublic dTDPublic = new DTDPublic();
            token = this.expect(Scanner.STRING);
            dTDPublic.pub = token.value;
            dTDPublic.system = null;
            token = this.scanner.peek();
            if (token.type == Scanner.STRING) {
                token = this.scanner.get();
                dTDPublic.system = token.value;
            }
            dTDNotation.externalID = dTDPublic;
        }
        this.expect(Scanner.GT);
    }

    @Override
    public DTDEntity expandEntity(String string) {
        return (DTDEntity)this.dtd.entities.get(string);
    }
}

