/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.dtd.NameKeySet;
import java.util.Iterator;
import java.util.TreeSet;

public final class LargeNameKeySet
extends NameKeySet {
    static final int MIN_HASH_AREA = 8;
    final boolean mNsAware;
    final NameKey[] mNames;
    final Bucket[] mBuckets;

    public LargeNameKeySet(boolean nsAware, NameKey[] names) {
        int tableSize;
        this.mNsAware = nsAware;
        int len = names.length;
        int minSize = len + (len + 7 >> 3);
        for (tableSize = 8; tableSize < minSize; tableSize += tableSize) {
        }
        this.mNames = new NameKey[tableSize];
        Bucket[] buckets = null;
        int mask = tableSize - 1;
        for (int i = 0; i < len; ++i) {
            Bucket old;
            NameKey nk = names[i];
            int ix = nk.hashCode() & mask;
            if (this.mNames[ix] == null) {
                this.mNames[ix] = nk;
                continue;
            }
            ix >>= 2;
            if (buckets == null) {
                buckets = new Bucket[tableSize >> 2];
                old = null;
            } else {
                old = buckets[ix];
            }
            buckets[ix] = new Bucket(nk, old);
        }
        this.mBuckets = buckets;
    }

    @Override
    public boolean hasMultiple() {
        return true;
    }

    @Override
    public boolean contains(NameKey name) {
        NameKey[] hashArea = this.mNames;
        int index = name.hashCode() & hashArea.length - 1;
        NameKey res = hashArea[index];
        if (res != null && res.equals(name)) {
            return true;
        }
        Bucket[] buckets = this.mBuckets;
        if (buckets != null) {
            for (Bucket bucket = buckets[index >> 2]; bucket != null; bucket = bucket.getNext()) {
                res = bucket.getName();
                if (!res.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void appendNames(StringBuffer sb, String sep) {
        int i;
        TreeSet<NameKey> ts = new TreeSet<NameKey>();
        for (i = 0; i < this.mNames.length; ++i) {
            NameKey name = this.mNames[i];
            if (name == null) continue;
            ts.add(name);
        }
        if (this.mBuckets != null) {
            for (i = 0; i < this.mNames.length >> 2; ++i) {
                for (Bucket b = this.mBuckets[i]; b != null; b = b.getNext()) {
                    ts.add(b.getName());
                }
            }
        }
        Iterator it = ts.iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(sep);
            }
            sb.append(it.next().toString());
        }
    }

    private static final class Bucket {
        final NameKey mName;
        final Bucket mNext;

        public Bucket(NameKey name, Bucket next) {
            this.mName = name;
            this.mNext = next;
        }

        public NameKey getName() {
            return this.mName;
        }

        public Bucket getNext() {
            return this.mNext;
        }

        public boolean contains(NameKey n) {
            return this.mName.equals(n);
        }
    }
}

